/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.helper;

import blusunrize.immersiveengineering.api.multiblocks.BlockMatcher;
import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityDummy;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockPartBlock;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.common.multiblocks.helper.ITQueueProcessor;
import mctmods.immersivetechnology.common.util.ITUtils;
import mctmods.immersivetechnology.core.lib.ITLib;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public abstract class ITTemplateMultiblock
extends TemplateMultiblock {
    public static final int DISASSEMBLE_QUEUE_SIZE = 8;
    private final MultiblockRegistration<?> logic;
    public static final List<ITQueueProcessor> pendingQueues = new ArrayList<ITQueueProcessor>();

    public ITTemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, MultiblockRegistration<?> logic) {
        super(loc, masterFromOrigin, triggerFromOrigin, size);
        this.logic = logic;
    }

    public ITTemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, List<BlockMatcher.MatcherPredicate> additionalPredicates, MultiblockRegistration<?> logic) {
        super(loc, masterFromOrigin, triggerFromOrigin, size, additionalPredicates);
        this.logic = logic;
    }

    public float getManualScale() {
        return 0.0f;
    }

    protected void replaceStructureBlock(StructureTemplate.StructureBlockInfo info, Level world, BlockPos actualPos, boolean mirrored, Direction clickDirection, Vec3i offsetFromMaster) {
        BlockState newState = ((MultiblockPartBlock)this.logic.block().get()).m_49966_();
        if ((newState = (BlockState)newState.m_61124_((Property)ITProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(!offsetFromMaster.equals((Object)Vec3i.f_123288_)))).m_61138_((Property)ITProperties.MIRRORED)) {
            newState = (BlockState)newState.m_61124_((Property)ITProperties.MIRRORED, (Comparable)Boolean.valueOf(mirrored));
        }
        if (newState.m_61138_((Property)ITProperties.FACING_HORIZONTAL)) {
            newState = (BlockState)newState.m_61124_((Property)ITProperties.FACING_HORIZONTAL, (Comparable)clickDirection.m_122424_());
        }
        if (newState.m_61138_((Property)ITProperties.ACTIVE)) {
            newState = (BlockState)newState.m_61124_((Property)ITProperties.ACTIVE, (Comparable)Boolean.valueOf(false));
        }
        BlockState oldState = world.m_8055_(actualPos);
        world.m_7731_(actualPos, newState, 3);
        BlockEntity curr = world.m_7702_(actualPos);
        if (curr instanceof MultiblockBlockEntityDummy) {
            MultiblockBlockEntityDummy dummy = (MultiblockBlockEntityDummy)curr;
            dummy.getHelper().setPositionInMB(info.f_74675_());
        } else if (!(curr instanceof MultiblockBlockEntityMaster)) {
            ITLib.IT_LOGGER.error("Expected MB TE at {} during placement", (Object)actualPos);
        }
        LevelChunk chunk = world.m_46745_(actualPos);
        world.markAndNotifyBlock(actualPos, chunk, oldState, newState, 3, 512);
    }

    public void disassemble(Level world, BlockPos origin, boolean mirrored, Direction clickDirectionAtCreation) {
        if (world.f_46443_) {
            return;
        }
        Mirror mirror = mirrored ? Mirror.FRONT_BACK : Mirror.NONE;
        Rotation rot = DirectionUtils.getRotationBetweenFacings((Direction)Direction.NORTH, (Direction)clickDirectionAtCreation);
        Preconditions.checkNotNull((Object)rot);
        ArrayList allDrops = new ArrayList();
        Consumer<ItemStack> addToDrops = stack -> {
            if (!stack.m_41619_()) {
                allDrops.add(stack);
            }
        };
        if (world instanceof ServerLevel) {
            BlockPos dropPos;
            Object mbBE;
            Object object;
            ServerLevel serverLevel = (ServerLevel)world;
            BlockPos masterPos = ITTemplateMultiblock.withSettingsAndOffset((BlockPos)origin, (BlockPos)this.masterFromOrigin, (Mirror)mirror, (Rotation)rot);
            ServerPlayer breakingPlayer = (ServerPlayer)serverLevel.m_5788_((double)masterPos.m_123341_() + 0.5, (double)masterPos.m_123342_() + 0.5, (double)masterPos.m_123343_() + 0.5, -1.0, e -> true);
            IMultiblockBEHelperMaster masterHelper = null;
            BlockEntity masterBE = world.m_7702_(masterPos);
            if (masterBE instanceof IMultiblockBE && (object = (mbBE = (IMultiblockBE)masterBE).getHelper()) instanceof IMultiblockBEHelperMaster) {
                IMultiblockBEHelperMaster h;
                masterHelper = h = (IMultiblockBEHelperMaster)object;
            }
            if (masterHelper != null) {
                this.dropInventory(masterHelper, addToDrops);
            }
            for (StructureTemplate.StructureBlockInfo block : this.getStructure(world)) {
                this.prepareBlockForDisassembly(world, ITTemplateMultiblock.withSettingsAndOffset((BlockPos)origin, (BlockPos)block.f_74675_(), (Mirror)mirror, (Rotation)rot));
            }
            ArrayList<StructureTemplate.StructureBlockInfo> structure = new ArrayList<StructureTemplate.StructureBlockInfo>(this.getStructure(world));
            structure.sort(Comparator.comparingInt(a -> -a.f_74675_().m_123342_()));
            ArrayList<AbstractMap.SimpleEntry<BlockPos, BlockState>> toBreak = new ArrayList<AbstractMap.SimpleEntry<BlockPos, BlockState>>();
            for (StructureTemplate.StructureBlockInfo info : structure) {
                BlockPos actualPos = ITTemplateMultiblock.withSettingsAndOffset((BlockPos)origin, (BlockPos)info.f_74675_(), (Mirror)mirror, (Rotation)rot);
                BlockState stateAfterMirror = info.f_74676_().m_60715_(mirror);
                BlockState templateState = stateAfterMirror.rotate((LevelAccessor)serverLevel, actualPos, rot);
                List drops = breakingPlayer != null ? Block.m_49874_((BlockState)templateState, (ServerLevel)serverLevel, (BlockPos)actualPos, null, (Entity)breakingPlayer, (ItemStack)breakingPlayer.m_21205_()) : Block.m_49869_((BlockState)templateState, (ServerLevel)serverLevel, (BlockPos)actualPos, null);
                for (ItemStack s : drops) {
                    addToDrops.accept(s);
                }
                toBreak.add(new AbstractMap.SimpleEntry<BlockPos, BlockState>(actualPos, templateState));
            }
            BlockPos blockPos = dropPos = breakingPlayer != null ? breakingPlayer.m_20183_() : origin;
            if (breakingPlayer != null) {
                BlockPos playerPos = breakingPlayer.m_20183_();
                double minDist = Double.MAX_VALUE;
                BlockPos closest = null;
                for (AbstractMap.SimpleEntry simpleEntry : toBreak) {
                    BlockPos actual = (BlockPos)simpleEntry.getKey();
                    double dist = actual.m_123331_((Vec3i)playerPos);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    closest = actual;
                }
                if (closest != null) {
                    dropPos = closest;
                }
            }
            for (ItemStack s : allDrops) {
                ITUtils.dropStackAtPos(world, dropPos, s);
            }
            pendingQueues.add(new ITQueueProcessor(world, toBreak, breakingPlayer));
        }
    }

    private <S extends IMultiblockState> void dropInventory(IMultiblockBEHelperMaster<S> helper, Consumer<ItemStack> dropIt) {
        helper.getMultiblock().logic().dropExtraItems((Object)helper.getState(), dropIt);
    }

    public Component getDisplayName() {
        return ((MultiblockPartBlock)this.logic.block().get()).m_49954_();
    }

    public Block getBlock() {
        return (Block)this.logic.block().get();
    }

    public Vec3i getSize(@Nullable Level world) {
        return this.size;
    }

    public void initializeClient(Consumer<ClientMultiblocks.MultiblockManualData> consumer) {
    }

    @Nonnull
    public TemplateMultiblock.TemplateData getTemplate(@Nullable Level world) {
        assert (world != null);
        TemplateMultiblock.TemplateData result = super.getTemplate(world);
        Vec3i resultSize = result.template().m_163801_();
        Preconditions.checkState((boolean)resultSize.equals((Object)this.size), (String)"Wrong template size for multiblock %s, template size: %s", (Object)this.getTemplateLocation(), (Object)resultSize);
        return result;
    }

    protected void prepareBlockForDisassembly(Level world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)be;
            multiblockBE.getHelper().markDisassembling();
        } else if (be != null) {
            ITLib.IT_LOGGER.error("Expected multiblock BE at {}, got {}", (Object)pos, (Object)be);
        }
    }
}

