/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.helper;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public record ITWrappingItemHandler(IItemHandler wrapped, boolean allowInsert, boolean allowExtract, List<IntRange> allowedRanges) implements IItemHandler
{
    public int getSlots() {
        return this.wrapped.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.wrapped.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.allowInsert || !this.isAccessible(slot)) {
            return stack;
        }
        return this.wrapped.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.allowExtract || !this.isAccessible(slot)) {
            return ItemStack.f_41583_;
        }
        return this.wrapped.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.wrapped.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isAccessible(slot) && this.wrapped.isItemValid(slot, stack);
    }

    private boolean isAccessible(int slot) {
        for (IntRange range : this.allowedRanges) {
            if (!range.contains(slot)) continue;
            return true;
        }
        return false;
    }

    public record IntRange(int first, int firstAfter) {
        private boolean contains(int slotId) {
            return slotId >= this.first && slotId < this.firstAfter;
        }
    }
}

