/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.stone.process;

import mctmods.immersivetechnology.common.multiblocks.stone.logic.CoolingTowerLogic;
import mctmods.immersivetechnology.common.multiblocks.stone.recipe.CoolingTowerRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CoolingTowerProcess {
    private final CoolingTowerRecipe recipe;
    private int ticksProcessed = 0;

    public CoolingTowerProcess(CoolingTowerRecipe recipe) {
        this.recipe = recipe;
    }

    public void tick(CoolingTowerLogic.State state) {
        if (this.ticksProcessed >= this.recipe.totalProcessTime) {
            return;
        }
        int perTickIn0 = this.recipe.input0.getAmount() / this.recipe.totalProcessTime;
        int perTickIn1 = this.recipe.input1.getAmount() / this.recipe.totalProcessTime;
        int perTickOut0 = this.recipe.fluidOutput0.getAmount() / this.recipe.totalProcessTime;
        int perTickOut1 = this.recipe.fluidOutput1.getAmount() / this.recipe.totalProcessTime;
        int perTickOut2 = this.recipe.fluidOutput2.getAmount() / this.recipe.totalProcessTime;
        state.tanks.input0().drain(perTickIn0, IFluidHandler.FluidAction.EXECUTE);
        state.tanks.input1().drain(perTickIn1, IFluidHandler.FluidAction.EXECUTE);
        if (!this.recipe.fluidOutput0.isEmpty()) {
            state.tanks.output0().fill(new FluidStack(this.recipe.fluidOutput0.getFluid(), perTickOut0), IFluidHandler.FluidAction.EXECUTE);
        }
        if (!this.recipe.fluidOutput1.isEmpty()) {
            state.tanks.output1().fill(new FluidStack(this.recipe.fluidOutput1.getFluid(), perTickOut1), IFluidHandler.FluidAction.EXECUTE);
        }
        if (!this.recipe.fluidOutput2.isEmpty()) {
            state.tanks.output2().fill(new FluidStack(this.recipe.fluidOutput2.getFluid(), perTickOut2), IFluidHandler.FluidAction.EXECUTE);
        }
        ++this.ticksProcessed;
        if (this.ticksProcessed == this.recipe.totalProcessTime) {
            int remIn0 = this.recipe.input0.getAmount() % this.recipe.totalProcessTime;
            int remIn1 = this.recipe.input1.getAmount() % this.recipe.totalProcessTime;
            int remOut0 = this.recipe.fluidOutput0.getAmount() % this.recipe.totalProcessTime;
            int remOut1 = this.recipe.fluidOutput1.getAmount() % this.recipe.totalProcessTime;
            int remOut2 = this.recipe.fluidOutput2.getAmount() % this.recipe.totalProcessTime;
            state.tanks.input0().drain(remIn0, IFluidHandler.FluidAction.EXECUTE);
            state.tanks.input1().drain(remIn1, IFluidHandler.FluidAction.EXECUTE);
            if (!this.recipe.fluidOutput0.isEmpty()) {
                state.tanks.output0().fill(new FluidStack(this.recipe.fluidOutput0.getFluid(), remOut0), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!this.recipe.fluidOutput1.isEmpty()) {
                state.tanks.output1().fill(new FluidStack(this.recipe.fluidOutput1.getFluid(), remOut1), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!this.recipe.fluidOutput2.isEmpty()) {
                state.tanks.output2().fill(new FluidStack(this.recipe.fluidOutput2.getFluid(), remOut2), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public boolean isComplete() {
        return this.ticksProcessed >= this.recipe.totalProcessTime;
    }
}

