/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.stone.recipe.builder;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import mctmods.immersivetechnology.common.multiblocks.stone.recipe.CoolingTowerRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class CoolingTowerRecipeBuilder
extends IEFinishedRecipe<CoolingTowerRecipeBuilder> {
    private int inputCount = 0;
    private int outputCount = 0;

    public CoolingTowerRecipeBuilder() {
        super((IERecipeSerializer)CoolingTowerRecipe.SERIALIZER.get());
    }

    public static CoolingTowerRecipeBuilder builder() {
        return new CoolingTowerRecipeBuilder();
    }

    public CoolingTowerRecipeBuilder addInput(TagKey<Fluid> fluidTag, int amount) {
        String key = "input" + this.inputCount;
        ++this.inputCount;
        return (CoolingTowerRecipeBuilder)this.addWriter(jsonObject -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("tag", fluidTag.f_203868_().toString());
            obj.addProperty("amount", (Number)amount);
            jsonObject.add(key, (JsonElement)obj);
        });
    }

    public CoolingTowerRecipeBuilder addOutput(FluidStack fluidStack) {
        String key = "output" + this.outputCount;
        ++this.outputCount;
        return (CoolingTowerRecipeBuilder)this.addWriter(jsonObject -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("fluid", Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid())).toString());
            obj.addProperty("amount", (Number)fluidStack.getAmount());
            jsonObject.add(key, (JsonElement)obj);
        });
    }

    public CoolingTowerRecipeBuilder addOutput(Fluid fluid, int amount) {
        return this.addOutput(new FluidStack(fluid, amount));
    }

    public CoolingTowerRecipeBuilder setTime(int time) {
        return (CoolingTowerRecipeBuilder)this.addWriter(jsonObject -> jsonObject.addProperty("time", (Number)time));
    }
}

