/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.core.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mctmods.immersivetechnology.common.blocks.helper.ITStairsBlock;
import mctmods.immersivetechnology.common.blocks.helper.ITWallBlock;
import mctmods.immersivetechnology.common.blocks.metal.BarrelCreativeBlock;
import mctmods.immersivetechnology.common.blocks.metal.BarrelOpenBlock;
import mctmods.immersivetechnology.common.blocks.metal.BarrelSteelBlock;
import mctmods.immersivetechnology.common.blocks.metal.TechnologyEngineeringBlock;
import mctmods.immersivetechnology.common.blocks.metal.TrashEnergyBlock;
import mctmods.immersivetechnology.common.blocks.metal.TrashFluidBlock;
import mctmods.immersivetechnology.common.blocks.metal.TrashItemBlock;
import mctmods.immersivetechnology.common.blocks.metal.ValveFluidBlock;
import mctmods.immersivetechnology.common.blocks.metal.ValveLoadBlock;
import mctmods.immersivetechnology.common.blocks.metal.logic.BarrelCreativeBlockEntity;
import mctmods.immersivetechnology.common.blocks.metal.logic.BarrelOpenBlockEntity;
import mctmods.immersivetechnology.common.blocks.metal.logic.BarrelSteelBlockEntity;
import mctmods.immersivetechnology.common.blocks.metal.logic.TrashEnergyBlockEntity;
import mctmods.immersivetechnology.common.blocks.metal.logic.TrashFluidBlockEntity;
import mctmods.immersivetechnology.common.blocks.metal.logic.TrashItemBlockEntity;
import mctmods.immersivetechnology.common.blocks.metal.logic.ValveFluidBlockEntity;
import mctmods.immersivetechnology.common.blocks.metal.logic.ValveLoadBlockEntity;
import mctmods.immersivetechnology.common.blocks.stone.ReinforcedCokeBrick;
import mctmods.immersivetechnology.common.blocks.stone.slab.SlabReinforcedCokeBrick;
import mctmods.immersivetechnology.common.items.helper.ITBlockItem;
import mctmods.immersivetechnology.core.registration.ITItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ITBlocks {
    public static final DeferredRegister<Block> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"immersivetechnology");
    public static final Map<ResourceLocation, BlockEntry<? extends SlabBlock>> TO_SLAB = new HashMap<ResourceLocation, BlockEntry<? extends SlabBlock>>();
    public static final Map<ResourceLocation, BlockEntry<? extends ITStairsBlock>> TO_STAIRS = new HashMap<ResourceLocation, BlockEntry<? extends ITStairsBlock>>();
    public static final Map<ResourceLocation, BlockEntry<? extends ITWallBlock>> TO_WALL = new HashMap<ResourceLocation, BlockEntry<? extends ITWallBlock>>();
    private static final HashMap<String, RegistryObject<? extends Block>> BLOCK_REGISTRY_MAP = new HashMap();
    public static Function<String, Block> getBlock = key -> (Block)BLOCK_REGISTRY_MAP.get(key).get();
    private static final Supplier<BlockBehaviour.Properties> METAL_PROPERTIES_NO_OVERLAY = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 15.0f).m_60999_().m_60971_((state, blockReader, pos) -> false);
    public static final Supplier<BlockBehaviour.Properties> METAL_PROPERTIES_NO_OCCLUSION = () -> METAL_PROPERTIES_NO_OVERLAY.get().m_60955_();

    public static void initBlocks() {
        MetalDevices.init();
        Stone.init();
        TO_SLAB.put(Stone.REINFORCED_COKE_BRICK.getId(), Stone.SLAB_REINFORCED_COKE_BRICK);
    }

    public static List<? extends Block> getITBlocks() {
        return REGISTER.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    public static void init(IEventBus event) {
        ITBlocks.initBlocks();
        REGISTER.register(event);
        for (BlockEntry<?> entry : BlockEntry.ALL_ENTRIES) {
            Function<Block, ITBlockItem> finalToItem = ITBlockItem::new;
            ITItems.REGISTER.register(entry.getId().m_135815_(), () -> (ITBlockItem)((Object)((Object)finalToItem.apply((Block)entry.get()))));
            BLOCK_REGISTRY_MAP.put(entry.getId().m_135815_(), entry.getRegObject());
        }
    }

    public static final class MetalDevices {
        public static BlockEntry<BarrelCreativeBlock> BARREL_CREATIVE;
        public static BlockEntry<BarrelSteelBlock> BARREL_STEEL;
        public static BlockEntry<BarrelOpenBlock> BARREL_OPEN;
        public static BlockEntry<TrashEnergyBlock> TRASH_ENERGY;
        public static BlockEntry<TrashFluidBlock> TRASH_FLUID;
        public static BlockEntry<TrashItemBlock> TRASH_ITEM;
        public static BlockEntry<ValveFluidBlock> VALVE_FLUID;
        public static BlockEntry<ValveLoadBlock> VALVE_LOAD;
        public static BlockEntry<TechnologyEngineeringBlock> TECHNOLOGY_ENGINEERING;

        private static void init() {
            BARREL_CREATIVE = new BlockEntry<BarrelCreativeBlock>("barrel_creative", () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 15.0f).m_60955_(), p -> new BarrelCreativeBlock(BarrelCreativeBlockEntity::new, (BlockBehaviour.Properties)p));
            BARREL_STEEL = new BlockEntry<BarrelSteelBlock>("barrel_steel", () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 15.0f).m_60955_(), p -> new BarrelSteelBlock(BarrelSteelBlockEntity::new, (BlockBehaviour.Properties)p));
            BARREL_OPEN = new BlockEntry<BarrelOpenBlock>("barrel_open", () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 15.0f).m_60955_(), p -> new BarrelOpenBlock(BarrelOpenBlockEntity::new, (BlockBehaviour.Properties)p));
            TRASH_ENERGY = new BlockEntry<TrashEnergyBlock>("trash_energy", () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 15.0f).m_60955_(), p -> new TrashEnergyBlock(TrashEnergyBlockEntity::new, (BlockBehaviour.Properties)p));
            TRASH_FLUID = new BlockEntry<TrashFluidBlock>("trash_fluid", () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 15.0f).m_60955_(), p -> new TrashFluidBlock(TrashFluidBlockEntity::new, (BlockBehaviour.Properties)p));
            TRASH_ITEM = new BlockEntry<TrashItemBlock>("trash_item", () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 15.0f).m_60955_(), p -> new TrashItemBlock(TrashItemBlockEntity::new, (BlockBehaviour.Properties)p));
            VALVE_FLUID = new BlockEntry<ValveFluidBlock>("valve_fluid", () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 15.0f).m_60955_(), p -> new ValveFluidBlock(ValveFluidBlockEntity::new, (BlockBehaviour.Properties)p));
            VALVE_LOAD = new BlockEntry<ValveLoadBlock>("valve_load", () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 15.0f).m_60955_(), p -> new ValveLoadBlock(ValveLoadBlockEntity::new, (BlockBehaviour.Properties)p));
            TECHNOLOGY_ENGINEERING = new BlockEntry<TechnologyEngineeringBlock>("technology_engineering", () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(3.0f, 15.0f), TechnologyEngineeringBlock::new);
        }
    }

    public static final class Stone {
        public static BlockEntry<ReinforcedCokeBrick> REINFORCED_COKE_BRICK;
        public static BlockEntry<SlabReinforcedCokeBrick> SLAB_REINFORCED_COKE_BRICK;

        private static void init() {
            REINFORCED_COKE_BRICK = new BlockEntry<ReinforcedCokeBrick>("reinforced_coke_brick", () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_), ReinforcedCokeBrick::new);
            SLAB_REINFORCED_COKE_BRICK = new BlockEntry<SlabReinforcedCokeBrick>("slab_reinforced_coke_brick", () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_), SlabReinforcedCokeBrick::new);
        }
    }

    public static final class BlockEntry<T extends Block>
    implements Supplier<T>,
    ItemLike {
        public static final Collection<BlockEntry<?>> ALL_ENTRIES = new ArrayList();
        private final RegistryObject<T> regObject;
        private final Supplier<BlockBehaviour.Properties> properties;

        public BlockEntry(String name, Supplier<BlockBehaviour.Properties> properties, Function<BlockBehaviour.Properties, T> make) {
            this.properties = properties;
            this.regObject = REGISTER.register(name, () -> (Block)make.apply((BlockBehaviour.Properties)properties.get()));
            ALL_ENTRIES.add(this);
        }

        @Override
        public T get() {
            return (T)((Block)this.regObject.get());
        }

        public ResourceLocation getId() {
            return this.regObject.getId();
        }

        public BlockBehaviour.Properties getProperties() {
            return this.properties.get();
        }

        @NotNull
        public Item m_5456_() {
            return this.get().m_5456_();
        }

        public RegistryObject<? extends Block> getRegObject() {
            return this.regObject;
        }
    }
}

