/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.client.gui.helper.ITContainerScreen;
import mctmods.immersivetechnology.client.gui.helper.ITFluidInfoArea;
import mctmods.immersivetechnology.client.gui.helper.ITInfoArea;
import mctmods.immersivetechnology.common.multiblocks.gui.BoilerTankMenu;
import mctmods.immersivetechnology.core.lib.ITLib;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;

public class BoilerTankScreen
extends ITContainerScreen<BoilerTankMenu> {
    private static final ResourceLocation TEXTURE = ITLib.makeTextureLocation("boiler_tank");

    public BoilerTankScreen(BoilerTankMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        float heatLevel = ((BoilerTankMenu)this.f_97732_).getHeatLevel();
        int barWidth = Mth.m_14045_((int)Math.round(41.0f * heatLevel / 100.0f), (int)0, (int)41);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 67, this.f_97736_ + 5, 176, 0, barWidth, 9);
    }

    @Override
    @Nonnull
    protected List<ITInfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new ITFluidInfoArea((IFluidTank)((BoilerTankMenu)this.f_97732_).tanks.input(), new Rect2i(this.f_97735_ + 67, this.f_97736_ + 20, 16, 47), 177, 31, 20, 51, TEXTURE), (Object)new ITFluidInfoArea((IFluidTank)((BoilerTankMenu)this.f_97732_).tanks.output(), new Rect2i(this.f_97735_ + 92, this.f_97736_ + 20, 16, 47), 177, 31, 20, 51, TEXTURE), (Object)new ITInfoArea(new Rect2i(this.f_97735_ + 67, this.f_97736_ + 5, 41, 9)){

            @Override
            protected void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
                tooltip.add((Component)Component.m_237113_((String)"Temperature"));
                float heatLevel = ((BoilerTankMenu)BoilerTankScreen.this.f_97732_).getHeatLevel();
                tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.RED) + (int)heatLevel + "/100 C")));
            }

            @Override
            public void draw(GuiGraphics graphics) {
            }
        });
    }

    @NotNull
    public BoilerTankMenu getMenu() {
        return (BoilerTankMenu)this.f_97732_;
    }
}

