/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.models.mirror;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.client.models.helper.ITCompositeBakedModel;
import mctmods.immersivetechnology.client.models.helper.ITICacheKeyProvider;
import mctmods.immersivetechnology.client.models.mirror.ITMirroredModelLoader;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class ITCachedMirroredModel<K, T extends ITICacheKeyProvider<K>>
extends ITCompositeBakedModel<T>
implements ITICacheKeyProvider<K> {
    private final LoadingCache<K, List<BakedQuad>> cache = CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.SECONDS).build(CacheLoader.from(k -> ITMirroredModelLoader.reversedQuads(base.getQuads(k))));

    public ITCachedMirroredModel(T base) {
        super(base);
    }

    @Override
    public List<BakedQuad> getQuads(K key) {
        return (List)this.cache.getUnchecked(key);
    }

    @Override
    @Nullable
    public K getKey(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        return ((ITICacheKeyProvider)this.base).getKey(state, side, rand, extraData, layer);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pSide, @Nonnull RandomSource pRand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        return super.getQuads(pState, pSide, pRand, extraData, layer);
    }
}

