/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.models.split;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.Polygon;
import malte0811.modelsplitter.model.UVCoords;
import malte0811.modelsplitter.model.Vertex;
import mctmods.immersivetechnology.client.models.helper.ITBakedQuadBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ITPolygonUtils {
    private static int getOffset(VertexFormatElement element) {
        int offset = 0;
        for (VertexFormatElement e : DefaultVertexFormat.f_85811_.m_86023_()) {
            if (e == element) {
                return offset / 4;
            }
            offset += e.m_86050_();
        }
        throw new IllegalStateException("Did not find element with usage " + element.m_86048_().name() + " and type " + element.m_86041_().name());
    }

    public static Polygon<ExtraQuadData> toPolygon(BakedQuad quad) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(4);
        int posOffset = ITPolygonUtils.getOffset(DefaultVertexFormat.f_85804_);
        int uvOffset = ITPolygonUtils.getOffset(DefaultVertexFormat.f_166849_);
        int normalOffset = ITPolygonUtils.getOffset(DefaultVertexFormat.f_85809_);
        int colorOffset = ITPolygonUtils.getOffset(DefaultVertexFormat.f_85805_);
        int color = quad.m_111303_()[colorOffset];
        for (int v = 0; v < 4; ++v) {
            int baseOffset = v * DefaultVertexFormat.f_85811_.m_86020_() / 4;
            int packedNormal = quad.m_111303_()[normalOffset + baseOffset];
            Vec3d normalVec = new Vec3d((double)((byte)packedNormal), (double)((byte)(packedNormal >> 8)), (double)((byte)(packedNormal >> 16))).normalize();
            UVCoords uv = new UVCoords((double)Float.intBitsToFloat(quad.m_111303_()[uvOffset + baseOffset]), (double)Float.intBitsToFloat(quad.m_111303_()[uvOffset + baseOffset + 1]));
            Vec3d pos = new Vec3d((double)Float.intBitsToFloat(quad.m_111303_()[baseOffset + posOffset]), (double)Float.intBitsToFloat(quad.m_111303_()[baseOffset + posOffset + 1]), (double)Float.intBitsToFloat(quad.m_111303_()[baseOffset + posOffset + 2]));
            vertices.add(new Vertex(pos, normalVec, uv));
            Preconditions.checkState((quad.m_111303_()[baseOffset + colorOffset] == color ? 1 : 0) != 0, (Object)"All vertices in a quad must have the same color, otherwise we need changes in BMS");
        }
        return new Polygon(vertices, (Object)new ExtraQuadData(quad.m_173410_(), new Vector4f((float)(color & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 24) / 255.0f)));
    }

    public static BakedQuad toBakedQuad(Polygon<ExtraQuadData> poly, ModelState transform) {
        return ITPolygonUtils.toBakedQuad(poly.getPoints(), (ExtraQuadData)poly.getTexture(), transform.m_6189_().blockCenterToCorner(), true);
    }

    public static BakedQuad toBakedQuad(List<Vertex> points, ExtraQuadData data, Transformation rotation, boolean absoluteUV) {
        Preconditions.checkArgument((points.size() == 4 ? 1 : 0) != 0);
        ITBakedQuadBuilder quadBuilder = new ITBakedQuadBuilder();
        Vector3f normal = new Vector3f();
        float u0 = data.sprite().m_118409_();
        float u1 = data.sprite().m_118410_();
        float v0 = data.sprite().m_118411_();
        float v1 = data.sprite().m_118412_();
        for (Vertex v : points) {
            double builder_v;
            double builder_u;
            Vector4f pos = new Vector4f();
            pos.set(ITPolygonUtils.toArray(v.position(), 4));
            normal.set(ITPolygonUtils.toArray(v.normal(), 3));
            rotation.transformPosition(pos);
            rotation.transformNormal(normal);
            pos.mul(1.0f / pos.w());
            double epsilon = 1.0E-5;
            for (int i = 0; i < 2; ++i) {
                if ((double)Math.abs((float)i - pos.x()) < 1.0E-5) {
                    pos.setComponent(0, (float)i);
                }
                if ((double)Math.abs((float)i - pos.y()) < 1.0E-5) {
                    pos.setComponent(1, (float)i);
                }
                if (!((double)Math.abs((float)i - pos.z()) < 1.0E-5)) continue;
                pos.setComponent(2, (float)i);
            }
            if (absoluteUV) {
                double abs_u = v.uv().u();
                double abs_v = v.uv().v();
                builder_u = (abs_u - (double)u0) / (double)(u1 - u0) * 16.0;
                builder_v = (abs_v - (double)v0) / (double)(v1 - v0) * 16.0;
            } else {
                builder_u = 16.0 * v.uv().u();
                builder_v = 16.0 * (1.0 - v.uv().v());
            }
            quadBuilder.putVertexData(new Vec3((double)pos.x(), (double)pos.y(), (double)pos.z()), new Vec3(normal), builder_u, builder_v, data.sprite(), new float[]{data.color.x(), data.color.y(), data.color.z(), data.color.w()}, 1.0f);
        }
        return quadBuilder.bake(-1, Direction.m_122372_((float)normal.x(), (float)normal.y(), (float)normal.z()), data.sprite(), true);
    }

    private static float[] toArray(Vec3d vec, int length) {
        int i;
        float[] ret = new float[length];
        for (i = 0; i < 3; ++i) {
            ret[i] = (float)vec.get(i);
        }
        for (i = 3; i < length; ++i) {
            ret[i] = 1.0f;
        }
        return ret;
    }

    public record ExtraQuadData(TextureAtlasSprite sprite, Vector4f color) {
    }
}

