/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.helper;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.blocks.helper.ITEnums;
import mctmods.immersivetechnology.common.blocks.helper.ITPlacementLimitation;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.core.registration.ITMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public class ITBlockInterfaces {

    public static interface IBlockOverlayText {
        @Nullable
        public Component[] getOverlayText(Player var1, HitResult var2, boolean var3);
    }

    public static interface IComparatorOverride {
        public int getComparatorInputOverride();
    }

    public static interface IRedstoneOutput {
        default public int getWeakRSOutput(Direction side) {
            return this.getStrongRSOutput(side);
        }

        public int getStrongRSOutput(Direction var1);

        public boolean canConnectRedstone(Direction var1);
    }

    public static interface IDirectionalBE {
        public Direction getFacing();

        public void setFacing(Direction var1);

        public ITPlacementLimitation getFacingLimitation();

        default public Direction getFacingForPlacement(BlockPlaceContext ctx) {
            Direction f = this.getFacingLimitation().getDirectionForPlacement(ctx);
            if (this.mirrorFacingOnPlacement((LivingEntity)ctx.m_43723_())) {
                return f.m_122424_();
            }
            return f;
        }

        default public boolean mirrorFacingOnPlacement(LivingEntity placer) {
            return false;
        }

        default public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
            return true;
        }

        default public void afterRotation() {
        }
    }

    public static interface IAdvancedDirectionalBE
    extends IDirectionalBE {
        public void onDirectionalPlacement(Direction var1, float var2, float var3, float var4, LivingEntity var5);
    }

    public static interface IConfigurableSides {
        public ITEnums.IOSideConfig getSideConfig(Direction var1);

        public boolean toggleSide(Direction var1, Player var2);
    }

    public static interface IBlockEntityDrop
    extends IPlacementInteraction {
        public void getBlockEntityDrop(LootContext var1, Consumer<ItemStack> var2);

        default public ItemStack getPickBlock(BlockState state) {
            BlockEntity tile = (BlockEntity)this;
            MutableObject drop = new MutableObject((Object)new ItemStack((ItemLike)state.m_60734_()));
            Level var7 = tile.m_58904_();
            if (var7 instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)var7;
                LootParams parms = new LootParams.Builder(world).m_287289_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81461_, (Object)world.m_8055_(tile.m_58899_())).m_287289_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)tile.m_58899_())).m_287235_(LootContextParamSets.f_81421_);
                LootContext var10001 = new LootContext.Builder(parms).m_287259_(ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"pick_block"));
                Objects.requireNonNull(drop);
                this.getBlockEntityDrop(var10001, arg_0 -> ((MutableObject)drop).setValue(arg_0));
            }
            return (ItemStack)drop.getValue();
        }
    }

    public static interface IAdditionalDrops {
        public Collection<ItemStack> getExtraDrops(Player var1, BlockState var2);
    }

    public static interface BlockStateProvider {
        public BlockState getState();

        public void setState(BlockState var1);
    }

    public static interface IEntityProof {
        public boolean canEntityDestroy(Entity var1);
    }

    public static interface IPlayerInteraction {
        public boolean interact(Direction var1, Player var2, InteractionHand var3, ItemStack var4, float var5, float var6, float var7);
    }

    public static interface IHammerInteraction {
        public boolean hammerUseSide(Direction var1, Player var2, InteractionHand var3, Vec3 var4);
    }

    public static interface IScrewdriverInteraction {
        public InteractionResult screwdriverUseSide(Direction var1, Player var2, InteractionHand var3, Vec3 var4);
    }

    public static interface IPlacementInteraction {
        public void onBEPlaced(BlockPlaceContext var1);
    }

    public static interface IMirrorAble
    extends BlockStateProvider {
        default public boolean getIsMirrored() {
            BlockState state = this.getState();
            if (state.m_61138_((Property)ITProperties.MIRRORED)) {
                return (Boolean)state.m_61143_((Property)ITProperties.MIRRORED);
            }
            return false;
        }

        default public void setMirrored(boolean mirrored) {
            BlockState oldState = this.getState();
            BlockState newState = (BlockState)oldState.m_61124_((Property)ITProperties.MIRRORED, (Comparable)Boolean.valueOf(mirrored));
            this.setState(newState);
        }
    }

    public static interface IBlockBounds
    extends ISelectionBounds,
    ICollisionBounds {
        @Nonnull
        public VoxelShape getBlockBounds(@Nullable CollisionContext var1);

        @Override
        @Nonnull
        default public VoxelShape getCollisionShape(CollisionContext ctx) {
            return this.getBlockBounds(ctx);
        }

        @Override
        @Nonnull
        default public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
            return this.getBlockBounds(ctx);
        }
    }

    public static interface ISelectionBounds {
        @Nonnull
        public VoxelShape getSelectionShape(@Nullable CollisionContext var1);
    }

    public static interface ICollisionBounds {
        @Nonnull
        public VoxelShape getCollisionShape(CollisionContext var1);
    }

    public static interface IHasDummyBlocks
    extends IGeneralMultiblock {
        public void placeDummies(BlockPlaceContext var1, BlockState var2);

        public void breakDummies(BlockPos var1, BlockState var2);
    }

    public static interface IGeneralMultiblock
    extends BlockStateProvider,
    IEBlockInterfaces.IGeneralMultiblock {
        @Nullable
        public IGeneralMultiblock master();

        default public boolean isDummy() {
            BlockState state = this.getState();
            return state.m_61138_((Property)ITProperties.MULTIBLOCKSLAVE) ? (Boolean)state.m_61143_((Property)ITProperties.MULTIBLOCKSLAVE) : true;
        }
    }

    public static interface IInteractionObjectIT<T extends BlockEntity>
    extends MenuProvider {
        @Nullable
        public T getGuiMaster();

        public ITMenuTypes.ArgContainer<? super T, ?> getContainerType();

        public boolean canUseGui(Player var1);

        default public boolean isValid() {
            return this.getGuiMaster() != null;
        }

        @Nonnull
        default public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
            T master = this.getGuiMaster();
            Preconditions.checkNotNull(master);
            ITMenuTypes.ArgContainer<T, ?> type = this.getContainerType();
            return type.create(id, playerInventory, master);
        }

        @Nonnull
        default public Component m_5446_() {
            return Component.m_237113_((String)"");
        }
    }
}

