/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.helper;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.blocks.helper.ITBaseBlock;
import mctmods.immersivetechnology.common.blocks.helper.ITBaseBlockEntity;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.helper.ITClientTickableBE;
import mctmods.immersivetechnology.common.blocks.helper.ITPlacementLimitation;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.common.blocks.helper.ITServerTickableBE;
import mctmods.immersivetechnology.core.registration.ITTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class ITEntityBlock<T extends BlockEntity>
extends ITBaseBlock
implements EntityBlock {
    private final BiFunction<BlockPos, BlockState, T> makeEntity;
    private BEClassInspectedData classData;
    private static final List<BooleanProperty> DEFAULT_OFF = ImmutableList.of((Object)ITProperties.MULTIBLOCKSLAVE, (Object)ITProperties.ACTIVE, (Object)ITProperties.MIRRORED);

    public ITEntityBlock(BiFunction<BlockPos, BlockState, T> makeEntity, BlockBehaviour.Properties blockProps) {
        this(makeEntity, blockProps, true);
    }

    public ITEntityBlock(BiFunction<BlockPos, BlockState, T> makeEntity, BlockBehaviour.Properties blockProps, boolean fitsIntoContainer) {
        super(blockProps, fitsIntoContainer);
        this.makeEntity = makeEntity;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return (BlockEntity)this.makeEntity.apply(pPos, pState);
    }

    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> m_142354_(Level world, @NotNull BlockState state, @NotNull BlockEntityType<U> type) {
        return this.getClassData().makeBaseTicker(world.f_46443_);
    }

    @Override
    protected BlockState getInitDefaultState() {
        BlockState ret = super.getInitDefaultState();
        if (ret.m_61138_((Property)ITProperties.FACING_ALL)) {
            ret = (BlockState)ret.m_61124_((Property)ITProperties.FACING_ALL, (Comparable)this.getDefaultFacing());
        } else if (ret.m_61138_((Property)ITProperties.FACING_HORIZONTAL)) {
            ret = (BlockState)ret.m_61124_((Property)ITProperties.FACING_HORIZONTAL, (Comparable)this.getDefaultFacing());
        }
        for (BooleanProperty defaultOff : DEFAULT_OFF) {
            if (!ret.m_61138_((Property)defaultOff)) continue;
            ret = (BlockState)ret.m_61124_((Property)defaultOff, (Comparable)Boolean.valueOf(false));
        }
        return ret;
    }

    public void m_6810_(BlockState state, Level world, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.m_7702_(pos);
        if (state.m_60734_() != newState.m_60734_()) {
            if (tile instanceof ITBaseBlockEntity) {
                ((ITBaseBlockEntity)tile).setOverrideState(state);
            }
            if (tile instanceof ITBlockInterfaces.IHasDummyBlocks) {
                ((ITBlockInterfaces.IHasDummyBlocks)tile).breakDummies(pos, state);
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_6240_(@NotNull Level world, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, BlockEntity tile, @NotNull ItemStack stack) {
        Collection<ItemStack> stacks;
        if (tile instanceof ITBlockInterfaces.IAdditionalDrops && !(stacks = ((ITBlockInterfaces.IAdditionalDrops)tile).getExtraDrops(player, state)).isEmpty()) {
            for (ItemStack s : stacks) {
                if (s.m_41619_()) continue;
                ITEntityBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)s);
            }
        }
        super.m_6240_(world, player, pos, state, tile, stack);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ITBlockInterfaces.IEntityProof) {
            return ((ITBlockInterfaces.IEntityProof)tile).canEntityDestroy(entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack s;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ITBlockInterfaces.IBlockEntityDrop && target instanceof BlockHitResult && !(s = ((ITBlockInterfaces.IBlockEntityDrop)tile).getPickBlock(world.m_8055_(pos))).m_41619_()) {
            return s;
        }
        Item item = this.m_5456_();
        return item == Items.f_41852_ ? ItemStack.f_41583_ : new ItemStack((ItemLike)item, 1);
    }

    @Override
    public boolean m_8133_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, worldIn, pos, eventID, eventParam);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }

    protected Direction getDefaultFacing() {
        return Direction.NORTH;
    }

    @Override
    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockEntity tile = world.m_7702_(pos);
        Player placer = context.m_43723_();
        Direction side = context.m_43719_();
        float hitX = (float)context.m_43720_().f_82479_ - (float)pos.m_123341_();
        float hitY = (float)context.m_43720_().f_82480_ - (float)pos.m_123342_();
        float hitZ = (float)context.m_43720_().f_82481_ - (float)pos.m_123343_();
        if (tile instanceof ITBlockInterfaces.IDirectionalBE) {
            ITBlockInterfaces.IDirectionalBE directionalBE = (ITBlockInterfaces.IDirectionalBE)tile;
            Direction f = directionalBE.getFacingForPlacement(context);
            directionalBE.setFacing(f);
            if (tile instanceof ITBlockInterfaces.IAdvancedDirectionalBE) {
                ITBlockInterfaces.IAdvancedDirectionalBE advDirectional = (ITBlockInterfaces.IAdvancedDirectionalBE)tile;
                advDirectional.onDirectionalPlacement(side, hitX, hitY, hitZ, (LivingEntity)placer);
            }
        }
        if (tile instanceof ITBlockInterfaces.IHasDummyBlocks) {
            ITBlockInterfaces.IHasDummyBlocks hasDummyBlocks = (ITBlockInterfaces.IHasDummyBlocks)tile;
            hasDummyBlocks.placeDummies(context, state);
        }
        if (tile instanceof ITBlockInterfaces.IPlacementInteraction) {
            ITBlockInterfaces.IPlacementInteraction placementInteractionBE = (ITBlockInterfaces.IPlacementInteraction)tile;
            placementInteractionBE.onBEPlaced(context);
        }
    }

    @Override
    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        BlockEntity tile = w.m_7702_(pos);
        if (tile instanceof ITBlockInterfaces.IHammerInteraction) {
            boolean b = ((ITBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, hand, hit.m_82450_());
            if (b) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.hammerUseSide(side, player, hand, w, pos, hit);
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        InteractionResult teResult;
        BlockEntity tile = w.m_7702_(pos);
        if (tile instanceof ITBlockInterfaces.IScrewdriverInteraction && (teResult = ((ITBlockInterfaces.IScrewdriverInteraction)tile).screwdriverUseSide(side, player, hand, hit.m_82450_())) != InteractionResult.PASS) {
            return teResult;
        }
        return super.screwdriverUseSide(side, player, hand, w, pos, hit);
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        boolean b;
        InteractionResult superResult = super.m_6227_(state, world, pos, player, hand, hit);
        if (superResult.m_19077_()) {
            return superResult;
        }
        Direction side = hit.m_82434_();
        float hitX = (float)hit.m_82450_().f_82479_ - (float)pos.m_123341_();
        float hitY = (float)hit.m_82450_().f_82480_ - (float)pos.m_123342_();
        float hitZ = (float)hit.m_82450_().f_82481_ - (float)pos.m_123343_();
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ITBlockInterfaces.IDirectionalBE && heldItem.m_204117_(ITTags.formationTools) && ((ITBlockInterfaces.IDirectionalBE)tile).canHammerRotate(side, hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)pos)), (LivingEntity)player) && !world.f_46443_) {
            Direction f = ((ITBlockInterfaces.IDirectionalBE)tile).getFacing();
            ITPlacementLimitation limit = ((ITBlockInterfaces.IDirectionalBE)tile).getFacingLimitation();
            f = switch (limit) {
                case ITPlacementLimitation.SIDE_CLICKED -> Direction.values()[Math.floorMod(f.ordinal() + (player.m_6144_() ? -1 : 1), 6)];
                case ITPlacementLimitation.PISTON_LIKE -> {
                    Direction.Axis axis = side.m_122434_();
                    Direction rotated = ITEntityBlock.rotateAround(f, axis);
                    if (player.m_6144_() != (side.m_122421_() == Direction.AxisDirection.NEGATIVE)) {
                        yield rotated.m_122424_();
                    }
                    yield rotated;
                }
                case ITPlacementLimitation.HORIZONTAL, ITPlacementLimitation.HORIZONTAL_PREFER_SIDE, ITPlacementLimitation.HORIZONTAL_QUADRANT, ITPlacementLimitation.HORIZONTAL_AXIS -> {
                    if (player.m_6144_() != side.equals((Object)Direction.DOWN)) {
                        yield f.m_122428_();
                    }
                    yield f.m_122427_();
                }
                default -> f;
            };
            ((ITBlockInterfaces.IDirectionalBE)tile).setFacing(f);
            ((ITBlockInterfaces.IDirectionalBE)tile).afterRotation();
            tile.m_6596_();
            world.m_7260_(pos, state, state, 3);
            world.m_7696_(tile.m_58899_(), tile.m_58900_().m_60734_(), 255, 0);
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof ITBlockInterfaces.IConfigurableSides && heldItem.m_204117_(ITTags.formationTools) && !world.f_46443_) {
            Direction configSide;
            Direction direction = configSide = player.m_6144_() ? side.m_122424_() : side;
            if (((ITBlockInterfaces.IConfigurableSides)tile).toggleSide(configSide, player)) {
                return InteractionResult.SUCCESS;
            }
        }
        if (tile instanceof ITBlockInterfaces.IPlayerInteraction && (b = ((ITBlockInterfaces.IPlayerInteraction)tile).interact(side, player, hand, heldItem, hitX, hitY, hitZ))) {
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)tile;
            if (hand == InteractionHand.MAIN_HAND && !player.m_6144_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (menuProvider instanceof ITBlockInterfaces.IInteractionObjectIT) {
                        ITBlockInterfaces.IInteractionObjectIT interaction = (ITBlockInterfaces.IInteractionObjectIT)menuProvider;
                        if ((interaction = (ITBlockInterfaces.IInteractionObjectIT)interaction.getGuiMaster()) != null && interaction.canUseGui(player)) {
                            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)interaction);
                        }
                    } else {
                        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)menuProvider);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return superResult;
    }

    private static Direction rotateAround(Direction dir, Direction.Axis axis) {
        if (dir.m_122434_() == axis) {
            return dir;
        }
        return dir.m_175362_(axis);
    }

    public void m_6861_(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        BlockEntity tile;
        if (!world.f_46443_ && (tile = world.m_7702_(pos)) instanceof ITBaseBlockEntity) {
            ((ITBaseBlockEntity)tile).onNeighborBlockChange(fromPos);
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        BlockEntity te;
        if (state.m_60734_() == this && (te = world.m_7702_(pos)) instanceof ITBlockInterfaces.ISelectionBounds) {
            return ((ITBlockInterfaces.ISelectionBounds)te).getSelectionShape(context);
        }
        return super.m_5940_(state, world, pos, context);
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (this.getClassData().customCollisionBounds()) {
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof ITBlockInterfaces.ICollisionBounds) {
                ITBlockInterfaces.ICollisionBounds collisionBounds = (ITBlockInterfaces.ICollisionBounds)te;
                return collisionBounds.getCollisionShape(context);
            }
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, world, pos, context);
    }

    @NotNull
    public VoxelShape m_6079_(@NotNull BlockState state, BlockGetter world, @NotNull BlockPos pos) {
        BlockEntity te;
        if (world.m_8055_(pos).m_60734_() == this && (te = world.m_7702_(pos)) instanceof ITBlockInterfaces.ISelectionBounds) {
            return ((ITBlockInterfaces.ISelectionBounds)te).getSelectionShape(null);
        }
        return super.m_6079_(state, world, pos);
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return this.getClassData().hasComparatorOutput;
    }

    public int m_6782_(@NotNull BlockState state, Level world, @NotNull BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ITBlockInterfaces.IComparatorOverride) {
            ITBlockInterfaces.IComparatorOverride compOverride = (ITBlockInterfaces.IComparatorOverride)te;
            return compOverride.getComparatorInputOverride();
        }
        return 0;
    }

    public int m_6378_(@NotNull BlockState blockState, BlockGetter world, @NotNull BlockPos pos, @NotNull Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ITBlockInterfaces.IRedstoneOutput) {
            ITBlockInterfaces.IRedstoneOutput rsOutput = (ITBlockInterfaces.IRedstoneOutput)te;
            return rsOutput.getWeakRSOutput(side);
        }
        return 0;
    }

    public int m_6376_(@NotNull BlockState blockState, BlockGetter world, @NotNull BlockPos pos, @NotNull Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ITBlockInterfaces.IRedstoneOutput) {
            ITBlockInterfaces.IRedstoneOutput rsOutput = (ITBlockInterfaces.IRedstoneOutput)te;
            return rsOutput.getStrongRSOutput(side);
        }
        return 0;
    }

    public boolean m_7899_(@NotNull BlockState state) {
        return this.getClassData().emitsRedstone();
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ITBlockInterfaces.IRedstoneOutput) {
            ITBlockInterfaces.IRedstoneOutput rsOutput = (ITBlockInterfaces.IRedstoneOutput)te;
            return rsOutput.canConnectRedstone(side);
        }
        return false;
    }

    public void m_7892_(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Entity entity) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ITBaseBlockEntity) {
            ((ITBaseBlockEntity)te).onEntityCollision(world, entity);
        }
    }

    private BEClassInspectedData getClassData() {
        if (this.classData == null) {
            BlockEntity tempBE = (BlockEntity)this.makeEntity.apply(BlockPos.f_121853_, this.getInitDefaultState());
            this.classData = new BEClassInspectedData(tempBE instanceof ITServerTickableBE, tempBE instanceof ITClientTickableBE, tempBE instanceof ITBlockInterfaces.IComparatorOverride, tempBE instanceof ITBlockInterfaces.IRedstoneOutput, tempBE instanceof ITBlockInterfaces.ICollisionBounds);
        }
        return this.classData;
    }

    private record BEClassInspectedData(boolean serverTicking, boolean clientTicking, boolean hasComparatorOutput, boolean emitsRedstone, boolean customCollisionBounds) {
        @Nullable
        public <U extends BlockEntity> BlockEntityTicker<U> makeBaseTicker(boolean isClient) {
            if (this.serverTicking && !isClient) {
                return ITServerTickableBE.makeTicker();
            }
            if (this.clientTicking && isClient) {
                return ITClientTickableBE.makeTicker();
            }
            return null;
        }
    }
}

