/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import mctmods.immersivetechnology.common.blocks.helper.ITBaseBlockEntity;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.helper.ITClientTickableBE;
import mctmods.immersivetechnology.common.blocks.helper.ITServerTickableBE;
import mctmods.immersivetechnology.common.network.ITOSDRequestMessage;
import mctmods.immersivetechnology.common.network.ITPacketHandler;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.ITClientConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public abstract class OSDCommonBlockEntity
extends ITBaseBlockEntity
implements ITServerTickableBE,
ITClientTickableBE,
ITBlockInterfaces.IBlockOverlayText {
    public long acceptedAmount = 0L;
    public long lastAcceptedAmount = 0L;
    public int secondCounter = 0;
    public int requestCooldown = 0;

    protected OSDCommonBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (descPacket) {
            this.lastAcceptedAmount = nbt.m_128454_("lastAcceptedAmount");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (descPacket) {
            nbt.m_128356_("lastAcceptedAmount", this.lastAcceptedAmount);
        }
    }

    @Override
    public void tickServer() {
        if (++this.secondCounter < 20) {
            return;
        }
        this.lastAcceptedAmount = this.acceptedAmount;
        this.acceptedAmount = 0L;
        this.secondCounter = 0;
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public void tickClient() {
        if (this.requestCooldown > 0) {
            --this.requestCooldown;
        }
    }

    public abstract TranslationKey text();

    @Override
    public Component[] getOverlayText(@NotNull Player player, @NotNull HitResult mop, boolean hammer) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_ && this.requestCooldown == 0) {
            ITPacketHandler.sendToServer(new ITOSDRequestMessage(this.f_58858_));
            this.requestCooldown = 20;
        }
        float value = ITClientConfig.perTickTrashCans ? (float)this.lastAcceptedAmount / 20.0f : (float)this.lastAcceptedAmount;
        return new Component[]{Component.m_237113_((String)this.text().format(Float.valueOf(value)))};
    }
}

