/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.logic;

import mctmods.immersivetechnology.common.blocks.helper.ITBaseBlockEntity;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.helper.ITClientTickableBE;
import mctmods.immersivetechnology.common.blocks.helper.ITPlacementLimitation;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.common.blocks.helper.ITServerTickableBE;
import mctmods.immersivetechnology.common.blocks.metal.ValveFluidBlock;
import mctmods.immersivetechnology.common.network.ITOSDRequestMessage;
import mctmods.immersivetechnology.common.network.ITPacketHandler;
import mctmods.immersivetechnology.common.util.TranslationKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class ValveCommonBlockEntity
extends ITBaseBlockEntity
implements ITServerTickableBE,
ITClientTickableBE,
MenuProvider,
ITBlockInterfaces.IDirectionalBE,
ITBlockInterfaces.IBlockOverlayText,
ITBlockInterfaces.IHammerInteraction {
    final TranslationKey overlayNormal;
    final TranslationKey overlaySneakingFirstLine;
    final TranslationKey overlaySneakingSecondLine;
    final int GuiID;
    public Direction facing = Direction.NORTH;
    public int packetLimit = 0;
    public int timeLimit = 0;
    public int keepSize = 0;
    public byte redstoneMode;
    public long acceptedAmount;
    public long lastAcceptedAmount;
    public int secondCounter;
    public int minuteCounter;
    public long average;
    public long lastAverage;
    public int packets;
    public int packetAverage;
    public int lastPacketAverage;
    public long[] averages = new long[60];
    public long[] packetTotals = new long[60];
    private int requestCooldown = 0;

    public ValveCommonBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, TranslationKey overlayNormal, TranslationKey overlaySneakingFirstLine, TranslationKey overlaySneakingSecondLine, int GuiID) {
        super(type, pos, state);
        this.overlayNormal = overlayNormal;
        this.overlaySneakingFirstLine = overlaySneakingFirstLine;
        this.overlaySneakingSecondLine = overlaySneakingSecondLine;
        this.GuiID = GuiID;
        this.redstoneMode = 1;
    }

    public void efficientSetChanged() {
        this.m_6596_();
    }

    public void calculateAverages() {
        long sum = 0L;
        for (long avg : this.averages) {
            sum += avg;
        }
        this.average = sum / 60L;
        sum = 0L;
        for (long avg : this.packetTotals) {
            sum += avg;
        }
        this.packetAverage = (int)(sum / 60L);
    }

    protected void updateBase() {
        int i;
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.efficientSetChanged();
        if (++this.secondCounter < 20) {
            return;
        }
        if (this.average == 0L && this.acceptedAmount > 0L) {
            for (i = 0; i < 60; ++i) {
                this.averages[i] = this.acceptedAmount;
            }
        }
        if (this.packetAverage == 0 && this.packets > 0) {
            for (i = 0; i < 60; ++i) {
                this.packetTotals[i] = this.packets;
            }
        }
        if (this.averages[this.minuteCounter] != this.acceptedAmount || this.packetTotals[this.minuteCounter] != (long)this.packets) {
            this.averages[this.minuteCounter] = this.acceptedAmount;
            this.packetTotals[this.minuteCounter] = this.packets;
            this.calculateAverages();
        }
        this.lastAcceptedAmount = this.acceptedAmount;
        this.acceptedAmount = 0L;
        this.packets = 0;
        this.secondCounter = 0;
        if (++this.minuteCounter == 60) {
            this.lastPacketAverage = this.packetAverage;
            this.lastAverage = this.average;
            this.minuteCounter = 0;
        }
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public void tickServer() {
        this.updateBase();
    }

    @Override
    public void tickClient() {
        if (this.requestCooldown > 0) {
            --this.requestCooldown;
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.facing = (Direction)this.m_58900_().m_61143_((Property)ITProperties.FACING_ALL);
    }

    @Override
    public Component[] getOverlayText(@NotNull Player player, @NotNull HitResult mop, boolean hammer) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_ && this.requestCooldown == 0) {
            ITPacketHandler.sendToServer(new ITOSDRequestMessage(this.f_58858_));
            this.requestCooldown = 20;
        }
        boolean open = (Boolean)this.m_58900_().m_61143_((Property)ValveFluidBlock.OPEN);
        if (player.m_6047_()) {
            double avg = open ? (double)this.average / 20.0 : 0.0;
            int pa = open ? this.packetAverage : 0;
            return new Component[]{Component.m_237113_((String)this.overlaySneakingFirstLine.format(avg)), Component.m_237113_((String)this.overlaySneakingSecondLine.format(pa))};
        }
        long la = open ? this.lastAcceptedAmount : 0L;
        return new Component[]{Component.m_237113_((String)this.overlayNormal.format(la))};
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.packetLimit = nbt.m_128451_("packetLimit");
        this.timeLimit = nbt.m_128451_("timeLimit");
        this.keepSize = nbt.m_128451_("keepSize");
        this.redstoneMode = nbt.m_128445_("redstoneMode");
        this.lastAcceptedAmount = nbt.m_128454_("lastAcceptedAmount");
        this.average = nbt.m_128454_("average");
        this.packetAverage = nbt.m_128451_("packetAverage");
        if (!descPacket) {
            this.acceptedAmount = nbt.m_128454_("acceptedAmount");
            this.secondCounter = nbt.m_128451_("secondCounter");
            this.minuteCounter = nbt.m_128451_("minuteCounter") % 60;
            if (nbt.m_128425_("averages", 12)) {
                this.averages = nbt.m_128467_("averages");
                if (this.averages.length != 60) {
                    this.averages = new long[60];
                }
            } else if (nbt.m_128425_("averages", 4)) {
                long avg = nbt.m_128454_("averages");
                for (int i = 0; i < 60; ++i) {
                    this.averages[i] = avg;
                }
            } else {
                this.averages = new long[60];
            }
            if (nbt.m_128425_("packetTotals", 12)) {
                this.packetTotals = nbt.m_128467_("packetTotals");
                if (this.packetTotals.length != 60) {
                    this.packetTotals = new long[60];
                }
            } else {
                this.packetTotals = new long[60];
            }
            this.calculateAverages();
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128405_("packetLimit", this.packetLimit);
        nbt.m_128405_("timeLimit", this.timeLimit);
        nbt.m_128405_("keepSize", this.keepSize);
        nbt.m_128344_("redstoneMode", this.redstoneMode);
        nbt.m_128356_("lastAcceptedAmount", this.lastAcceptedAmount);
        nbt.m_128356_("average", this.average);
        nbt.m_128405_("packetAverage", this.packetAverage);
        if (!descPacket) {
            nbt.m_128356_("acceptedAmount", this.acceptedAmount);
            nbt.m_128405_("secondCounter", this.secondCounter);
            nbt.m_128405_("minuteCounter", this.minuteCounter);
            nbt.m_128388_("averages", this.averages);
            nbt.m_128388_("packetTotals", this.packetTotals);
        }
    }

    @Override
    @NotNull
    public Direction getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(@NotNull Direction facing) {
        this.facing = facing;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.m_58900_();
            if (state.m_61138_((Property)ITProperties.FACING_ALL)) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ITProperties.FACING_ALL, (Comparable)facing), 3);
            }
            this.markContainingBlockForUpdate(null);
            for (Direction d : Direction.values()) {
                this.f_58857_.m_46586_(this.f_58858_.m_121945_(d), this.m_58900_().m_60734_(), this.f_58858_);
            }
        }
        this.efficientSetChanged();
    }

    @Override
    @NotNull
    public ITPlacementLimitation getFacingLimitation() {
        return ITPlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(@NotNull LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(@NotNull Direction side, @NotNull Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean hammerUseSide(@NotNull Direction side, @NotNull Player player, @NotNull InteractionHand hand, @NotNull Vec3 hit) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return false;
        }
        boolean counter = player.m_6144_() != (side == Direction.DOWN);
        Direction oldFacing = this.facing;
        Direction newFacing = counter ? oldFacing.m_175364_(side.m_122434_()) : oldFacing.m_175362_(side.m_122434_());
        this.setFacing(newFacing);
        return true;
    }

    public int getRSPower() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_277086_(this.f_58858_);
    }

    public void updateRedstoneState() {
        if (this.redstoneMode == 0) {
            return;
        }
        int rs = this.getRSPower();
        boolean shouldOpen = this.redstoneMode == 1 ? rs == 0 : rs > 0;
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)ValveFluidBlock.OPEN) != shouldOpen) {
            assert (this.f_58857_ != null);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ValveFluidBlock.OPEN, (Comparable)Boolean.valueOf(shouldOpen)), 3);
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void receiveMessageFromClient(CompoundTag nbt) {
        this.packetLimit = nbt.m_128451_("packetLimit");
        this.timeLimit = nbt.m_128451_("timeLimit");
        this.keepSize = nbt.m_128451_("keepSize");
        this.efficientSetChanged();
        this.markContainingBlockForUpdate(null);
    }

    public static int longToInt(long value) {
        return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (value < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value);
    }

    public abstract AbstractContainerMenu m_7208_(int var1, @NotNull Inventory var2, @NotNull Player var3);

    @NotNull
    public abstract Component m_5446_();

    public abstract boolean stillValid(Player var1);
}

