/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.integration.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mctmods.immersivetechnology.client.gui.BoilerLiquidScreen;
import mctmods.immersivetechnology.client.gui.BoilerSolidScreen;
import mctmods.immersivetechnology.client.gui.BoilerTankScreen;
import mctmods.immersivetechnology.client.gui.DistillerScreen;
import mctmods.immersivetechnology.client.gui.SolarScreen;
import mctmods.immersivetechnology.client.gui.helper.ITFluidInfoArea;
import mctmods.immersivetechnology.common.integration.jei.JEIRecipeTypes;
import mctmods.immersivetechnology.common.integration.jei.category.ITBoilerLiquidCategory;
import mctmods.immersivetechnology.common.integration.jei.category.ITBoilerSolidCategory;
import mctmods.immersivetechnology.common.integration.jei.category.ITBoilerTankCategory;
import mctmods.immersivetechnology.common.integration.jei.category.ITCoolingTowerCategory;
import mctmods.immersivetechnology.common.integration.jei.category.ITDistillerCategory;
import mctmods.immersivetechnology.common.integration.jei.category.ITGasTurbineCategory;
import mctmods.immersivetechnology.common.integration.jei.category.ITSolarMelterCategory;
import mctmods.immersivetechnology.common.integration.jei.category.ITSolarTowerCategory;
import mctmods.immersivetechnology.common.integration.jei.category.ITSteamTurbineCategory;
import mctmods.immersivetechnology.common.multiblocks.gui.BoilerLiquidMenu;
import mctmods.immersivetechnology.common.multiblocks.gui.BoilerSolidMenu;
import mctmods.immersivetechnology.common.multiblocks.gui.DistillerMenu;
import mctmods.immersivetechnology.common.multiblocks.gui.SolarMenu;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerLiquidRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerSolidRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerTankRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.DistillerRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.GasTurbineRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SolarMelterRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SolarTowerRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SteamTurbineRecipe;
import mctmods.immersivetechnology.common.multiblocks.stone.recipe.CoolingTowerRecipe;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"main");
    private static IIngredientManager ingredientManager;

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ITBoilerLiquidCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ITBoilerSolidCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ITBoilerTankCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ITCoolingTowerCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ITDistillerCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ITGasTurbineCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ITSolarMelterCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ITSolarTowerCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ITSteamTurbineCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JEIRecipeTypes.BOILER_LIQUID, this.getBoilerLiquidRecipes());
        registration.addRecipes(JEIRecipeTypes.BOILER_SOLID, this.getBoilerSolidRecipes());
        registration.addRecipes(JEIRecipeTypes.BOILER_TANK, this.getBoilerRecipes());
        registration.addRecipes(JEIRecipeTypes.COOLING_TOWER, this.getCoolingTowerRecipes());
        registration.addRecipes(JEIRecipeTypes.DISTILLER, this.getDistillerRecipes());
        registration.addRecipes(JEIRecipeTypes.GAS_TURBINE, this.getGasTurbineRecipes());
        registration.addRecipes(JEIRecipeTypes.SOLAR_MELTER, this.getSolarMelterRecipes());
        registration.addRecipes(JEIRecipeTypes.SOLAR_TOWER, this.getSolarTowerRecipes());
        registration.addRecipes(JEIRecipeTypes.STEAM_TURBINE, this.getSteamTurbineRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(ITMultiblockProvider.BOILER_LIQUID.iconStack(), new RecipeType[]{JEIRecipeTypes.BOILER_LIQUID});
        registration.addRecipeCatalyst(ITMultiblockProvider.BOILER_SOLID.iconStack(), new RecipeType[]{JEIRecipeTypes.BOILER_SOLID});
        registration.addRecipeCatalyst(ITMultiblockProvider.BOILER_TANK.iconStack(), new RecipeType[]{JEIRecipeTypes.BOILER_TANK});
        registration.addRecipeCatalyst(ITMultiblockProvider.COOLING_TOWER.iconStack(), new RecipeType[]{JEIRecipeTypes.COOLING_TOWER});
        registration.addRecipeCatalyst(ITMultiblockProvider.DISTILLER.iconStack(), new RecipeType[]{JEIRecipeTypes.DISTILLER});
        registration.addRecipeCatalyst(ITMultiblockProvider.GAS_TURBINE.iconStack(), new RecipeType[]{JEIRecipeTypes.GAS_TURBINE});
        registration.addRecipeCatalyst(ITMultiblockProvider.SOLAR_MELTER.iconStack(), new RecipeType[]{JEIRecipeTypes.SOLAR_MELTER});
        registration.addRecipeCatalyst(ITMultiblockProvider.SOLAR_TOWER.iconStack(), new RecipeType[]{JEIRecipeTypes.SOLAR_TOWER});
        registration.addRecipeCatalyst(ITMultiblockProvider.STEAM_TURBINE.iconStack(), new RecipeType[]{JEIRecipeTypes.STEAM_TURBINE});
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(BoilerLiquidScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BoilerLiquidScreen>(){

            @NotNull
            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(@NotNull BoilerLiquidScreen gui, double mouseX, double mouseY) {
                int relX = (int)(mouseX - (double)gui.getLeftPos());
                int relY = (int)(mouseY - (double)gui.getTopPos());
                FluidStack fs = null;
                Rect2i area = null;
                if (relX >= 80 && relX < 96 && relY >= 20 && relY < 67) {
                    fs = ((BoilerLiquidMenu)gui.m_6262_()).tanks.input1().getFluid();
                    area = new Rect2i(gui.getLeftPos() + 80, gui.getTopPos() + 20, 16, 47);
                }
                if (fs != null && fs.getAmount() > 0) {
                    final Rect2i finalArea = area;
                    return ingredientManager.createTypedIngredient((IIngredientType)ForgeTypes.FLUID_STACK, fs).map(typedIngredient -> new IClickableIngredient<FluidStack>(){

                        @NotNull
                        public ITypedIngredient<FluidStack> getTypedIngredient() {
                            return typedIngredient;
                        }

                        @NotNull
                        public Rect2i getArea() {
                            return finalArea;
                        }
                    });
                }
                return Optional.empty();
            }

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull BoilerLiquidScreen gui, double guiMouseX, double guiMouseY) {
                ArrayList<IGuiClickableArea> areas = new ArrayList<IGuiClickableArea>();
                areas.add(JEIIntegration.createBoilerLiquidClickableArea((IFluidTank)((BoilerLiquidMenu)gui.m_6262_()).tanks.input1()));
                return areas;
            }
        });
        registration.addGuiContainerHandler(BoilerSolidScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BoilerSolidScreen>(){

            @NotNull
            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(@NotNull BoilerSolidScreen gui, double mouseX, double mouseY) {
                int relX = (int)(mouseX - (double)gui.getLeftPos());
                int relY = (int)(mouseY - (double)gui.getTopPos());
                ItemStack is = ItemStack.f_41583_;
                Rect2i area = null;
                if (relX >= 80 && relX < 98 && relY >= 53 && relY < 71) {
                    is = ((BoilerSolidMenu)gui.m_6262_()).m_38853_(0).m_7993_();
                    area = new Rect2i(gui.getLeftPos() + 80, gui.getTopPos() + 53, 18, 18);
                }
                if (!is.m_41619_()) {
                    final Rect2i finalArea = area;
                    return ingredientManager.createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)is).map(typedIngredient -> new IClickableIngredient<ItemStack>(){

                        @NotNull
                        public ITypedIngredient<ItemStack> getTypedIngredient() {
                            return typedIngredient;
                        }

                        @NotNull
                        public Rect2i getArea() {
                            assert (finalArea != null);
                            return finalArea;
                        }
                    });
                }
                return Optional.empty();
            }

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull BoilerSolidScreen gui, double guiMouseX, double guiMouseY) {
                ArrayList<IGuiClickableArea> areas = new ArrayList<IGuiClickableArea>();
                areas.add(JEIIntegration.createBoilerSolidClickableArea());
                return areas;
            }
        });
        registration.addGuiContainerHandler(DistillerScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<DistillerScreen>(){

            @NotNull
            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(@NotNull DistillerScreen gui, double mouseX, double mouseY) {
                int relX = (int)(mouseX - (double)gui.getLeftPos());
                int relY = (int)(mouseY - (double)gui.getTopPos());
                FluidStack fs = null;
                Rect2i area = null;
                if (relX >= 56 && relX < 76 && relY >= 19 && relY < 70) {
                    fs = ((DistillerMenu)gui.m_6262_()).tanks.input().getFluid();
                    area = new Rect2i(gui.getLeftPos() + 56, gui.getTopPos() + 19, 20, 51);
                } else if (relX >= 112 && relX < 132 && relY >= 19 && relY < 70) {
                    fs = ((DistillerMenu)gui.m_6262_()).tanks.output().getFluid();
                    area = new Rect2i(gui.getLeftPos() + 112, gui.getTopPos() + 19, 20, 51);
                }
                if (fs != null && fs.getAmount() > 0) {
                    final Rect2i finalArea = area;
                    return ingredientManager.createTypedIngredient((IIngredientType)ForgeTypes.FLUID_STACK, fs).map(typedIngredient -> new IClickableIngredient<FluidStack>(){

                        @NotNull
                        public ITypedIngredient<FluidStack> getTypedIngredient() {
                            return typedIngredient;
                        }

                        @NotNull
                        public Rect2i getArea() {
                            return finalArea;
                        }
                    });
                }
                return Optional.empty();
            }

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull DistillerScreen gui, double guiMouseX, double guiMouseY) {
                ArrayList<IGuiClickableArea> areas = new ArrayList<IGuiClickableArea>();
                areas.add(JEIIntegration.createDistillerClickableArea(56, (IFluidTank)((DistillerMenu)gui.m_6262_()).tanks.input()));
                areas.add(JEIIntegration.createDistillerClickableArea(112, (IFluidTank)((DistillerMenu)gui.m_6262_()).tanks.output()));
                return areas;
            }
        });
        registration.addGuiContainerHandler(BoilerTankScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BoilerTankScreen>(){

            @NotNull
            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(@NotNull BoilerTankScreen gui, double mouseX, double mouseY) {
                int relX = (int)(mouseX - (double)gui.getLeftPos());
                int relY = (int)(mouseY - (double)gui.getTopPos());
                FluidStack fs = null;
                Rect2i area = null;
                if (relX >= 65 && relX < 85 && relY >= 18 && relY < 69) {
                    fs = gui.getMenu().tanks.input().getFluid();
                    area = new Rect2i(gui.getLeftPos() + 65, gui.getTopPos() + 18, 20, 51);
                } else if (relX >= 90 && relX < 110 && relY >= 18 && relY < 69) {
                    fs = gui.getMenu().tanks.output().getFluid();
                    area = new Rect2i(gui.getLeftPos() + 90, gui.getTopPos() + 18, 20, 51);
                }
                if (fs != null && fs.getAmount() > 0) {
                    final Rect2i finalArea = area;
                    return ingredientManager.createTypedIngredient((IIngredientType)ForgeTypes.FLUID_STACK, fs).map(typedIngredient -> new IClickableIngredient<FluidStack>(){

                        @NotNull
                        public ITypedIngredient<FluidStack> getTypedIngredient() {
                            return typedIngredient;
                        }

                        @NotNull
                        public Rect2i getArea() {
                            return finalArea;
                        }
                    });
                }
                return Optional.empty();
            }

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull BoilerTankScreen gui, double guiMouseX, double guiMouseY) {
                ArrayList<IGuiClickableArea> areas = new ArrayList<IGuiClickableArea>();
                areas.add(JEIIntegration.createBoilerClickableArea(65, (IFluidTank)gui.getMenu().tanks.input()));
                areas.add(JEIIntegration.createBoilerClickableArea(90, (IFluidTank)gui.getMenu().tanks.output()));
                return areas;
            }
        });
        registration.addGuiContainerHandler(SolarScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<SolarScreen>(){

            @NotNull
            public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(@NotNull SolarScreen gui, double mouseX, double mouseY) {
                int relX = (int)(mouseX - (double)gui.getLeftPos());
                int relY = (int)(mouseY - (double)gui.getTopPos());
                FluidStack fs = null;
                Rect2i area = null;
                if (relX >= 102 && relX < 118 && relY >= 21 && relY < 68) {
                    fs = ((SolarMenu)gui.m_6262_()).inputTank.getFluid();
                    area = new Rect2i(gui.getLeftPos() + 102, gui.getTopPos() + 21, 16, 47);
                } else if (relX >= 126 && relX < 142 && relY >= 21 && relY < 68) {
                    fs = ((SolarMenu)gui.m_6262_()).outputTank.getFluid();
                    area = new Rect2i(gui.getLeftPos() + 126, gui.getTopPos() + 21, 16, 47);
                }
                if (fs != null && fs.getAmount() > 0) {
                    final Rect2i finalArea = area;
                    return ingredientManager.createTypedIngredient((IIngredientType)ForgeTypes.FLUID_STACK, fs).map(typedIngredient -> new IClickableIngredient<FluidStack>(){

                        @NotNull
                        public ITypedIngredient<FluidStack> getTypedIngredient() {
                            return typedIngredient;
                        }

                        @NotNull
                        public Rect2i getArea() {
                            return finalArea;
                        }
                    });
                }
                return Optional.empty();
            }

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull SolarScreen gui, double guiMouseX, double guiMouseY) {
                ArrayList<IGuiClickableArea> areas = new ArrayList<IGuiClickableArea>();
                areas.add(JEIIntegration.createSolarClickableArea(102, (IFluidTank)((SolarMenu)gui.m_6262_()).inputTank, gui));
                areas.add(JEIIntegration.createSolarClickableArea(126, (IFluidTank)((SolarMenu)gui.m_6262_()).outputTank, gui));
                return areas;
            }
        });
    }

    private static IGuiClickableArea createBoilerLiquidClickableArea(final IFluidTank tank) {
        final Rect2i area = new Rect2i(80, 20, 16, 47);
        return new IGuiClickableArea(){

            @NotNull
            public Rect2i getArea() {
                return area;
            }

            public void getTooltip(@NotNull ITooltipBuilder tooltip) {
                FluidStack fs = tank.getFluid();
                ITFluidInfoArea.fillTooltip(fs, tank.getCapacity(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0));
                tooltip.add((FormattedText)Component.m_237115_((String)"jei.tooltip.show.recipes"));
            }

            public void onClick(@NotNull IFocusFactory focusFactory, @NotNull IRecipesGui recipesGui) {
                recipesGui.showTypes(List.of(JEIRecipeTypes.BOILER_LIQUID));
            }
        };
    }

    private static IGuiClickableArea createBoilerSolidClickableArea() {
        final Rect2i area = new Rect2i(81, 35, 14, 14);
        return new IGuiClickableArea(){

            @NotNull
            public Rect2i getArea() {
                return area;
            }

            public void getTooltip(@NotNull ITooltipBuilder tooltip) {
                tooltip.add((FormattedText)Component.m_237115_((String)"jei.tooltip.show.recipes"));
            }

            public void onClick(@NotNull IFocusFactory focusFactory, @NotNull IRecipesGui recipesGui) {
                recipesGui.showTypes(List.of(JEIRecipeTypes.BOILER_SOLID));
            }
        };
    }

    private static IGuiClickableArea createBoilerClickableArea(int x, final IFluidTank tank) {
        final Rect2i area = new Rect2i(x, 18, 20, 51);
        return new IGuiClickableArea(){

            @NotNull
            public Rect2i getArea() {
                return area;
            }

            public void getTooltip(@NotNull ITooltipBuilder tooltip) {
                FluidStack fs = tank.getFluid();
                ITFluidInfoArea.fillTooltip(fs, tank.getCapacity(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0));
                tooltip.add((FormattedText)Component.m_237115_((String)"jei.tooltip.show.recipes"));
            }

            public void onClick(@NotNull IFocusFactory focusFactory, @NotNull IRecipesGui recipesGui) {
                recipesGui.showTypes(List.of(JEIRecipeTypes.BOILER_TANK));
            }
        };
    }

    private static IGuiClickableArea createDistillerClickableArea(int x, final IFluidTank tank) {
        final Rect2i area = new Rect2i(x, 19, 20, 51);
        return new IGuiClickableArea(){

            @NotNull
            public Rect2i getArea() {
                return area;
            }

            public void getTooltip(@NotNull ITooltipBuilder tooltip) {
                FluidStack fs = tank.getFluid();
                ITFluidInfoArea.fillTooltip(fs, tank.getCapacity(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0));
                tooltip.add((FormattedText)Component.m_237115_((String)"jei.tooltip.show.recipes"));
            }

            public void onClick(@NotNull IFocusFactory focusFactory, @NotNull IRecipesGui recipesGui) {
                recipesGui.showTypes(List.of(JEIRecipeTypes.DISTILLER));
            }
        };
    }

    private static IGuiClickableArea createSolarClickableArea(int x, final IFluidTank tank, final SolarScreen gui) {
        final Rect2i area = new Rect2i(x, 21, 16, 47);
        return new IGuiClickableArea(){

            @NotNull
            public Rect2i getArea() {
                return area;
            }

            public void getTooltip(@NotNull ITooltipBuilder tooltip) {
                FluidStack fs = tank.getFluid();
                ITFluidInfoArea.fillTooltip(fs, tank.getCapacity(), arg_0 -> ((ITooltipBuilder)tooltip).add(arg_0));
                tooltip.add((FormattedText)Component.m_237115_((String)"jei.tooltip.show.recipes"));
            }

            public void onClick(@NotNull IFocusFactory focusFactory, @NotNull IRecipesGui recipesGui) {
                recipesGui.showTypes(List.of(gui.isMelter ? JEIRecipeTypes.SOLAR_MELTER : JEIRecipeTypes.SOLAR_TOWER));
            }
        };
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        ingredientManager = jeiRuntime.getIngredientManager();
    }

    private List<BoilerLiquidRecipe> getBoilerLiquidRecipes() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        return new ArrayList<BoilerLiquidRecipe>(BoilerLiquidRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }

    private List<BoilerSolidRecipe> getBoilerSolidRecipes() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        return new ArrayList<BoilerSolidRecipe>(BoilerSolidRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }

    private List<BoilerTankRecipe> getBoilerRecipes() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        return new ArrayList<BoilerTankRecipe>(BoilerTankRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }

    private List<CoolingTowerRecipe> getCoolingTowerRecipes() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        return new ArrayList<CoolingTowerRecipe>(CoolingTowerRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }

    private List<DistillerRecipe> getDistillerRecipes() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        return new ArrayList<DistillerRecipe>(DistillerRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }

    private List<GasTurbineRecipe> getGasTurbineRecipes() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        return new ArrayList<GasTurbineRecipe>(GasTurbineRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }

    private List<SolarMelterRecipe> getSolarMelterRecipes() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        return new ArrayList<SolarMelterRecipe>(SolarMelterRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }

    private List<SolarTowerRecipe> getSolarTowerRecipes() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        return new ArrayList<SolarTowerRecipe>(SolarTowerRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }

    private List<SteamTurbineRecipe> getSteamTurbineRecipes() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        return new ArrayList<SteamTurbineRecipe>(SteamTurbineRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_));
    }
}

