/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.helper;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.common.multiblocks.helper.ITTemplateMultiblock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public class ITClientMultiblockProperties
implements ClientMultiblocks.MultiblockManualData {
    private final ITTemplateMultiblock multiblock;
    @Nullable
    private NonNullList<ItemStack> materials;
    private final ItemStack renderStack;
    @Nullable
    private final Vec3 renderOffset;

    public ITClientMultiblockProperties(ITTemplateMultiblock multiblock, double offX, double offY, double offZ) {
        this(multiblock, new Vec3(offX, offY, offZ));
    }

    private ITClientMultiblockProperties(ITTemplateMultiblock multiblock, @Nullable Vec3 renderOffset) {
        this.multiblock = multiblock;
        this.renderStack = new ItemStack((ItemLike)multiblock.getBlock());
        this.renderOffset = renderOffset;
    }

    protected boolean usingCustomRendering() {
        return false;
    }

    public NonNullList<ItemStack> getTotalMaterials() {
        if (this.materials == null) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            List structure = this.multiblock.getStructure((Level)Minecraft.m_91087_().f_91073_);
            this.materials = NonNullList.m_122779_();
            for (StructureTemplate.StructureBlockInfo info : structure) {
                if (info.f_74676_().m_61138_((Property)ITProperties.MULTIBLOCKSLAVE) && ((Boolean)info.f_74676_().m_61143_((Property)ITProperties.MULTIBLOCKSLAVE)).booleanValue()) continue;
                ItemStack picked = Utils.getPickBlock((BlockState)info.f_74676_());
                boolean added = false;
                for (ItemStack existing : this.materials) {
                    if (!ItemStack.m_41656_((ItemStack)existing, (ItemStack)picked)) continue;
                    existing.m_41769_(1);
                    added = true;
                    break;
                }
                if (added) continue;
                this.materials.add((Object)picked.m_41777_());
            }
        }
        return this.materials;
    }

    public boolean canRenderFormedStructure() {
        return this.renderOffset != null;
    }

    public void renderExtras(PoseStack matrix, MultiBufferSource buffer) {
    }

    public void renderCustomFormedStructure(PoseStack matrix, MultiBufferSource buffer) {
    }

    public final void renderFormedStructure(PoseStack matrix, MultiBufferSource buffer) {
        Objects.requireNonNull(this.renderOffset);
        if (this.usingCustomRendering()) {
            this.renderCustomFormedStructure(matrix, buffer);
            return;
        }
        matrix.m_85837_(this.renderOffset.f_82479_, this.renderOffset.f_82480_, this.renderOffset.f_82481_);
        Minecraft.m_91087_().m_91291_().m_269128_(this.renderStack, ItemDisplayContext.NONE, 0xF000F0, OverlayTexture.f_118083_, matrix, buffer, null, 0);
        matrix.m_85836_();
        this.renderExtras(matrix, buffer);
        matrix.m_85849_();
    }
}

