/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.helper;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ITFurnaceHandler<R extends IESerializableRecipe> {
    private double process = 0.0;
    private double processMax = 0.0;
    private double burnTime = 0.0;
    private double lastBurnTime = 0.0;
    public final ITFurnaceStateView stateView = new ITFurnaceStateView();
    private final int fuelSlot;
    private final List<InputSlot<R>> inputs;
    private final List<OutputSlot<R>> outputs;
    private final ToIntFunction<R> getProcessingTime;
    private final Runnable setChanged;

    public ITFurnaceHandler(int fuelSlot, List<InputSlot<R>> inputs, List<OutputSlot<R>> outputs, ToIntFunction<R> getProcessingTime, Runnable setChanged) {
        this.fuelSlot = fuelSlot;
        this.inputs = inputs;
        this.outputs = outputs;
        this.getProcessingTime = getProcessingTime;
        this.setChanged = setChanged;
    }

    public boolean tickServer(IMultiblockContext<? extends IFurnaceEnvironment<R>> ctx) {
        IItemHandlerModifiable inv;
        ItemStack fuel;
        int addedBurntime;
        boolean active = false;
        IFurnaceEnvironment env = (IFurnaceEnvironment)ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        if (this.burnTime > 0.0) {
            R recipe;
            double processSpeed = env.getProcessSpeed(ctx.getLevel());
            this.burnTime -= processSpeed;
            if (this.process > 0.0) {
                if (this.isAnyInputEmpty((IItemHandler)env.getInventory())) {
                    this.process = 0.0;
                    this.processMax = 0.0;
                } else {
                    recipe = this.getRecipe(env, level);
                    if (recipe != null && (double)this.getProcessTime(recipe) != this.processMax) {
                        this.processMax = 0.0;
                        this.process = 0.0;
                    } else {
                        this.process -= processSpeed;
                        processSpeed = 0.0;
                        active = true;
                    }
                }
                this.setChanged.run();
            }
            if (this.process <= 0.0) {
                if (this.processMax > 0.0) {
                    this.doRecipeIO(env, level);
                    this.processMax = 0.0;
                    this.burnTime -= this.process;
                }
                if ((recipe = this.getRecipe(env, level)) != null) {
                    double time = this.getProcessTime(recipe);
                    this.process = time - processSpeed;
                    this.processMax = time;
                    active = true;
                }
            }
        }
        if (this.burnTime <= 0.0 && this.getRecipe(env, level) != null && (addedBurntime = env.getBurnTimeOf(level, fuel = (inv = env.getInventory()).getStackInSlot(this.fuelSlot))) > 0) {
            this.lastBurnTime = addedBurntime;
            this.burnTime += this.lastBurnTime;
            if (fuel.hasCraftingRemainingItem() && fuel.m_41613_() == 1) {
                inv.setStackInSlot(this.fuelSlot, fuel.getCraftingRemainingItem());
            } else {
                fuel.m_41774_(1);
            }
            this.setChanged.run();
        }
        if (!active) {
            env.turnOff(ctx.getLevel());
        }
        return active;
    }

    public Tag toNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128347_("process", this.process);
        result.m_128347_("processMax", this.processMax);
        result.m_128347_("burnTime", this.burnTime);
        result.m_128347_("lastBurnTime", this.lastBurnTime);
        return result;
    }

    public void readNBT(Tag nbt) {
        if (!(nbt instanceof CompoundTag)) {
            return;
        }
        CompoundTag compound = (CompoundTag)nbt;
        this.process = compound.m_128459_("process");
        this.processMax = compound.m_128459_("processMax");
        this.burnTime = compound.m_128459_("burnTime");
        this.lastBurnTime = compound.m_128459_("lastBurnTime");
    }

    private boolean isAnyInputEmpty(IItemHandler inv) {
        for (InputSlot<R> i : this.inputs) {
            if (!inv.getStackInSlot(i.slotIndex).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private R getRecipe(IFurnaceEnvironment<R> env, Level level) {
        R recipe = env.getRecipeForInput(level);
        if (recipe == null) {
            return null;
        }
        IItemHandlerModifiable inv = env.getInventory();
        for (OutputSlot<R> out : this.outputs) {
            ItemStack currentStack = inv.getStackInSlot(out.slotIndex);
            ItemStack outputSlot = out.get(recipe);
            if (currentStack.m_41619_()) continue;
            if (!ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)outputSlot)) {
                return null;
            }
            if (currentStack.m_41613_() + outputSlot.m_41613_() <= inv.getSlotLimit(out.slotIndex)) continue;
            return null;
        }
        return recipe;
    }

    private void doRecipeIO(IFurnaceEnvironment<R> env, Level level) {
        R recipe = this.getRecipe(env, level);
        if (recipe == null) {
            return;
        }
        IItemHandlerModifiable inv = env.getInventory();
        for (InputSlot<R> inputSlot : this.inputs) {
            int reqSize = this.inputs.stream().map(matchSlot -> matchSlot.get(recipe)).filter(ingredient -> ingredient.test(inv.getStackInSlot(slot.slotIndex))).mapToInt(IngredientWithSize::getCount).findFirst().orElse(0);
            inv.getStackInSlot(inputSlot.slotIndex).m_41774_(reqSize);
        }
        for (OutputSlot outputSlot : this.outputs) {
            ItemStack result = outputSlot.get(recipe);
            if (result.m_41619_()) continue;
            if (!inv.getStackInSlot(outputSlot.slotIndex).m_41619_()) {
                inv.getStackInSlot(outputSlot.slotIndex).m_41769_(result.m_41613_());
                continue;
            }
            inv.setStackInSlot(outputSlot.slotIndex, result.m_41777_());
        }
    }

    private int getProcessTime(R recipe) {
        return this.getProcessingTime.applyAsInt(recipe);
    }

    public class ITFurnaceStateView
    implements ContainerData {
        public static final int LAST_BURN_TIME = 0;
        public static final int BURN_TIME = 1;
        public static final int PROCESS_MAX = 2;
        public static final int CURRENT_PROCESS = 3;
        public static final int NUM_SLOTS = 4;

        public static int getLastBurnTime(ContainerData data) {
            return data.m_6413_(0);
        }

        public static int getBurnTime(ContainerData data) {
            return data.m_6413_(1);
        }

        public static int getMaxProcess(ContainerData data) {
            return data.m_6413_(2);
        }

        public static int getProcess(ContainerData data) {
            return data.m_6413_(3);
        }

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> (int)ITFurnaceHandler.this.lastBurnTime;
                case 1 -> (int)ITFurnaceHandler.this.burnTime;
                case 2 -> (int)ITFurnaceHandler.this.processMax;
                case 3 -> (int)ITFurnaceHandler.this.process;
                default -> throw new IllegalArgumentException("Unknown index " + index);
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ITFurnaceHandler.this.lastBurnTime = value;
                    break;
                }
                case 1: {
                    ITFurnaceHandler.this.burnTime = value;
                    break;
                }
                case 2: {
                    ITFurnaceHandler.this.processMax = value;
                    break;
                }
                case 3: {
                    ITFurnaceHandler.this.process = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    }

    public static interface IFurnaceEnvironment<R extends IESerializableRecipe> {
        public IItemHandlerModifiable getInventory();

        @Nullable
        public R getRecipeForInput(Level var1);

        public int getBurnTimeOf(Level var1, ItemStack var2);

        public double getProcessSpeed(IMultiblockLevel var1);

        public void turnOff(IMultiblockLevel var1);
    }

    public record InputSlot<R>(Function<R, IngredientWithSize> getFromRecipe, int slotIndex) {
        public IngredientWithSize get(R recipe) {
            return this.getFromRecipe.apply(recipe);
        }
    }

    public record OutputSlot<R>(Function<R, Lazy<ItemStack>> getFromRecipe, int slotIndex) {
        public ItemStack get(R recipe) {
            return (ItemStack)this.getFromRecipe.apply(recipe).get();
        }
    }
}

