/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.helper;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlockEntity;
import java.util.List;
import mctmods.immersivetechnology.common.fluids.helper.ITMarkableFluidTank;
import mctmods.immersivetechnology.common.util.ITUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface ITPressurizedFluidOutput<State extends IMultiblockState> {
    public List<BlockPos> getOutputPositions();

    public Direction getOutputDirection(IMultiblockContext<State> var1);

    public List<ITMarkableFluidTank> getOutputTanks(State var1);

    public List<CapabilityReference<IFluidHandler>> getFluidOutputs(State var1);

    default public List<RelativeBlockFace> getOutputFacings() {
        return null;
    }

    default public int getTransferSpeed() {
        return Integer.MAX_VALUE;
    }

    default public boolean shouldPumpOutputs(IMultiblockContext<State> ctx) {
        return true;
    }

    default public void pumpOutputs(IMultiblockContext<State> ctx) {
        IMultiblockState state = (IMultiblockState)ctx.getState();
        if (!this.shouldPumpOutputs(ctx)) {
            return;
        }
        boolean dirty = false;
        Level level = ctx.getLevel().getRawLevel();
        List<BlockPos> outputPositions = this.getOutputPositions();
        Direction singleOutputDir = this.getOutputDirection(ctx);
        List<RelativeBlockFace> facings = this.getOutputFacings();
        List<ITMarkableFluidTank> tanks = this.getOutputTanks(state);
        List<CapabilityReference<IFluidHandler>> refs = this.getFluidOutputs(state);
        for (int i = 0; i < tanks.size(); ++i) {
            boolean hadTag;
            CapabilityReference<IFluidHandler> ref;
            ITMarkableFluidTank tank = tanks.get(i);
            if (tank.getFluidAmount() == 0 || !(ref = refs.get(i)).isPresent()) continue;
            IFluidHandler handler = (IFluidHandler)ref.get();
            BlockPos portAbs = ctx.getLevel().toAbsolute(outputPositions.get(i));
            Direction outputDir = singleOutputDir;
            if (facings != null && !facings.isEmpty()) {
                outputDir = ctx.getLevel().toAbsolute(facings.get(i));
            }
            if (!1.$assertionsDisabled && outputDir == null) {
                throw new AssertionError();
            }
            BlockPos externalAbs = portAbs.m_121945_(outputDir);
            BlockEntity adjTE = level.m_7702_(externalAbs);
            boolean isPipe = adjTE instanceof FluidPipeBlockEntity;
            FluidStack fs = tank.getFluid().copy();
            if (fs == null) continue;
            int transferSpeed = this.getTransferSpeed();
            if (transferSpeed != Integer.MAX_VALUE && !isPipe) {
                fs = ITUtils.copyFluidStackWithAmount(fs, Math.min(transferSpeed, fs.getAmount()), false);
            }
            boolean bl = hadTag = fs.hasTag() && fs.getTag().m_128441_("pressurized");
            if (isPipe && !hadTag) {
                fs.getOrCreateTag().m_128379_("pressurized", true);
            }
            int accepted = handler.fill(fs, IFluidHandler.FluidAction.SIMULATE);
            if (!hadTag && fs.hasTag()) {
                fs.getTag().m_128473_("pressurized");
            }
            if (accepted <= 0) continue;
            FluidStack toFill = ITUtils.copyFluidStackWithAmount(fs, Math.min(fs.getAmount(), accepted), false);
            if (isPipe) {
                toFill.getOrCreateTag().m_128379_("pressurized", true);
            }
            int drained = handler.fill(toFill, IFluidHandler.FluidAction.EXECUTE);
            tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            dirty = true;
        }
        if (dirty) {
            ctx.markMasterDirty();
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

