/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mctmods.immersivetechnology.api.HeatCapabilities;
import mctmods.immersivetechnology.api.capability.IHeatConsumer;
import mctmods.immersivetechnology.api.capability.IHeatProvider;
import mctmods.immersivetechnology.client.particles.ColoredSmoke;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.helper.ITMultiBlockInventoryUtils;
import mctmods.immersivetechnology.common.multiblocks.helper.ITSlotwiseItemHandler;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerSolidRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.BoilerSolidShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.core.ITCommonConfig;
import mctmods.immersivetechnology.core.lib.ITSound;
import mctmods.immersivetechnology.core.registration.ITSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BoilerSolidLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int INPUT_FUEL_SLOT = 0;
    private static final double HEAT_LOSS_PER_TICK = 0.2;
    private static final double WORKING_HEAT_LEVEL = 100.0;
    public static final double PILOT_HEAT = 20.0;
    private static final int PILOT_MULTIPLIER = 15;
    private static final double DEFAULT_HEAT_PER_TICK = 0.1;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])BoilerSolidShape.DATA.pointsOfInterest);
    private static final int WIDTH = BoilerSolidShape.WIDTH;
    private static final int LENGTH = BoilerSolidShape.LENGTH;
    public static final BlockPos REDSTONE_POI = BoilerSolidLogic.getPosList("redstone").get(0);
    public static final List<BlockPos> IGNITION_POI = BoilerSolidLogic.getPosList("ignition");
    private static final List<BlockPos> ITEM_INPUT_POI = BoilerSolidLogic.getPosList("item_input");
    private static final List<BlockPos> HEAT_OUTPUT_POI = BoilerSolidLogic.getPosList("heat_output");
    private static final List<BlockPos> SOUND_POI = BoilerSolidLogic.getPosList("sound");
    private static final List<BlockPos> EXHAUST_POI = BoilerSolidLogic.getPosList("exhaust");
    private static final RelativeBlockFace ITEM_INPUT_FACING = BoilerSolidLogic.getFacing("item_input");
    private static final RelativeBlockFace HEAT_OUTPUT_FACING = BoilerSolidLogic.getFacing("heat_output");
    public static final RelativeBlockFace IGNITION_FACING = BoilerSolidLogic.getFacing("ignition");

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    private static RelativeBlockFace getFacing(String name) {
        List facings = RAW_POIS.stream().filter(poi -> poi.name.equals(name)).flatMap(poi -> poi.relativeFaces.stream()).distinct().toList();
        if (facings.size() != 1) {
            throw new RuntimeException("Inconsistent facings for POI: " + name);
        }
        return (RelativeBlockFace)facings.get(0);
    }

    public void tickClient(IMultiblockContext<State> ctx) {
        boolean hasWater;
        State state = (State)ctx.getState();
        BlockPos soundAbs = ctx.getLevel().toAbsolute(SOUND_POI.get(0));
        Vec3 soundPos = new Vec3((double)soundAbs.m_123341_() + 0.5, (double)soundAbs.m_123342_() + 0.5, (double)soundAbs.m_123343_() + 0.5);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float attenuation = (float)Math.max(player.m_20238_(soundPos) / 8.0, 1.0);
        float currentLevel = (float)(state.heatLevel / 100.0);
        float vol = 2.0f * currentLevel / attenuation;
        if (state.heatLevel > 0.0 && vol > 0.01f && !state.isSoundPlaying.getAsBoolean()) {
            state.isSoundPlaying = ITSound.startSound(() -> state.heatLevel > 0.0, ctx.isValid(), soundPos, ITSounds.boiler_liquid, () -> {
                LocalPlayer p = Minecraft.m_91087_().f_91074_;
                if (p == null) {
                    return Float.valueOf(0.0f);
                }
                float a = (float)Math.max(p.m_20238_(soundPos) / 8.0, 1.0);
                return Float.valueOf(2.0f * (float)(state.heatLevel / 100.0) / a);
            }, () -> Float.valueOf((float)(state.heatLevel / 100.0)));
        }
        Level level = ctx.getLevel().getRawLevel();
        if (state.pilotLit) {
            BlockPos exhaustAbs = ctx.getLevel().toAbsolute(EXHAUST_POI.get(0));
            Vec3 flamePos = new Vec3((double)exhaustAbs.m_123341_() + 0.5, (double)exhaustAbs.m_123342_() + 0.1, (double)exhaustAbs.m_123343_() + 0.5);
            double velX = (double)level.f_46441_.m_188501_() * 0.0625 - 0.03125;
            double velY = 0.0625;
            double velZ = (double)level.f_46441_.m_188501_() * 0.0625 - 0.03125;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, flamePos.f_82479_, flamePos.f_82480_, flamePos.f_82481_, velX, velY, velZ);
        }
        boolean bl = hasWater = state.boilerInput.isPresent() && ((IHeatConsumer)state.boilerInput.get()).getFluidAmount() > 0;
        if (state.pilotLit && state.heatLevel > 20.0 && state.rsState.isEnabled(ctx) && hasWater) {
            BlockPos exhaustAbs = ctx.getLevel().toAbsolute(EXHAUST_POI.get(0));
            Vec3 smokePos = new Vec3((double)exhaustAbs.m_123341_() + 0.5, (double)exhaustAbs.m_123342_() + 1.25, (double)exhaustAbs.m_123343_() + 0.5);
            double velX = 0.0;
            double velY = 0.125;
            double velZ = 0.0;
            float r = 0.2f;
            float g = 0.2f;
            float b = 0.2f;
            level.m_7107_((ParticleOptions)new ColoredSmoke(r, g, b), smokePos.f_82479_, smokePos.f_82480_, smokePos.f_82481_, velX, velY, velZ);
        }
        if (state.needClientBlockUpdate) {
            this.updateAllBlocks(ctx, level, state.active);
            state.needClientBlockUpdate = false;
        }
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        boolean isActive;
        State state = (State)ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        if (!state.isInitialServerUpdateDone) {
            this.updateAllBlocks(ctx, level, state.active);
            state.isInitialServerUpdateDone = true;
        }
        boolean update = false;
        double previousHeatLevel = state.heatLevel;
        boolean hasWater = state.boilerInput.isPresent() && ((IHeatConsumer)state.boilerInput.get()).getFluidAmount() > 0;
        boolean fullMode = state.rsState.isEnabled(ctx) && hasWater;
        boolean bl = isActive = state.pilotLit && fullMode && state.heatLevel >= 100.0;
        if (!ctx.isValid().getAsBoolean()) {
            state.active = false;
            isActive = false;
            update = true;
        }
        if (state.active != isActive) {
            state.active = isActive;
            update = true;
            this.updateAllBlocks(ctx, level, state.active);
            state.needClientBlockUpdate = true;
        }
        if (!state.pilotLit) {
            state.heatLevel = Math.max(state.heatLevel - 0.2, 0.0);
            state.burnRemaining = 0;
            state.totalBurnTime = 0;
        } else if (state.burnRemaining > 0) {
            boolean consumeThisTick;
            boolean bl2 = consumeThisTick = fullMode || level.m_46467_() % 15L == 0L;
            if (consumeThisTick) {
                --state.burnRemaining;
            }
            state.heatLevel = fullMode ? Math.min(state.heatLevel + state.heatPerTick, 100.0) : Math.max(state.heatLevel - 0.2, 20.0);
        } else {
            state.totalBurnTime = 0;
            ItemStack fuelStack = state.inventory.getStackInSlot(0);
            BoilerSolidRecipe recipe = null;
            if (!fuelStack.m_41619_()) {
                recipe = BoilerSolidRecipe.findRecipe(level, fuelStack);
            }
            ItemStack single = fuelStack.m_41777_();
            single.m_41764_(1);
            int burnTimePerItem = ForgeHooks.getBurnTime((ItemStack)single, (RecipeType)RecipeType.f_44108_);
            double heatPerTick = 0.1;
            int consumeAmount = 1;
            if (recipe != null) {
                heatPerTick = recipe.getHeatPerTick();
                consumeAmount = recipe.input.getCount();
                if (burnTimePerItem <= 0) {
                    burnTimePerItem = 200;
                }
            }
            if (burnTimePerItem <= 0) {
                state.pilotLit = false;
                state.heatLevel = Math.max(state.heatLevel - 0.2, 0.0);
            } else {
                ItemStack consumed = state.inventory.getRawHandler().extractItem(0, consumeAmount, false);
                if (consumed.m_41613_() == consumeAmount) {
                    state.totalBurnTime = state.burnRemaining = burnTimePerItem * consumeAmount / ITCommonConfig.burnTimeDivider;
                    state.heatPerTick = heatPerTick;
                    state.pilotLit = true;
                } else {
                    state.pilotLit = false;
                    state.heatLevel = Math.max(state.heatLevel - 0.2, 0.0);
                }
            }
        }
        if (previousHeatLevel != state.heatLevel) {
            update = true;
        }
        if (update) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
    }

    private void updateAllBlocks(IMultiblockContext<State> ctx, Level level, boolean active) {
        ResourceLocation boilerRL = ResourceLocation.fromNamespaceAndPath((String)"immersivetechnology", (String)"boiler_solid");
        Block boilerBlock = (Block)ForgeRegistries.BLOCKS.getValue(boilerRL);
        if (boilerBlock == null) {
            return;
        }
        for (int y = 0; y < BoilerSolidShape.HEIGHT; ++y) {
            for (int z = 0; z < LENGTH; ++z) {
                for (int x = 0; x < WIDTH; ++x) {
                    BlockState newState;
                    BlockPos relPos = new BlockPos(x, y, z);
                    BlockPos absPos = ctx.getLevel().toAbsolute(relPos);
                    BlockState curr = level.m_8055_(absPos);
                    if (curr.m_60734_() != boilerBlock || !curr.m_61138_((Property)ITProperties.ACTIVE) || curr.equals(newState = (BlockState)curr.m_61124_((Property)ITProperties.ACTIVE, (Comparable)Boolean.valueOf(active)))) continue;
                    level.m_7731_(absPos, newState, 19);
                    level.m_46672_(absPos, boilerBlock);
                    if (!level.f_46443_) continue;
                    Minecraft.m_91087_().f_91060_.m_109721_(absPos, curr, newState);
                }
            }
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        BlockPos localPos = position.posInMultiblock();
        RelativeBlockFace side = position.side();
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (ITEM_INPUT_POI.contains(localPos) && (side == null || side == ITEM_INPUT_FACING)) {
                return ((State)ctx.getState()).inputFuelCap.cast(ctx);
            }
        } else if (cap == HeatCapabilities.HEAT_PROVIDER_CAPABILITY && HEAT_OUTPUT_POI.contains(localPos) && (side == null || side == HEAT_OUTPUT_FACING)) {
            return ((State)ctx.getState()).heatSourceCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        ITMultiBlockInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    public State createInitialState(IInitialMultiblockContext<State> ctx) {
        return new State(ctx);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return BoilerSolidShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ITDisplayContext {
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public StoredCapability<IItemHandlerModifiable> inputFuelCap;
        public StoredCapability<IHeatProvider> heatSourceCap;
        public CapabilityReference<IHeatConsumer> boilerInput;
        public ITSlotwiseItemHandler inventory;
        public double heatLevel = 0.0;
        public int burnRemaining = 0;
        public int totalBurnTime = 0;
        public double heatPerTick = 0.0;
        public boolean pilotLit = false;
        public boolean active = false;
        public BooleanSupplier isSoundPlaying = () -> false;
        public boolean isInitialServerUpdateDone = false;
        public boolean needClientBlockUpdate = true;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            Runnable onChanged = () -> {
                markDirty.run();
                sync.run();
            };
            this.inventory = new FuelItemHandler(ctx.levelSupplier(), List.of(ITSlotwiseItemHandler.IOConstraint.INPUT), onChanged);
            this.inputFuelCap = new StoredCapability((Object)this.inventory);
            this.heatSourceCap = new StoredCapability((Object)new HeatSourceImpl(this));
            MultiblockFace heatMBFace = new MultiblockFace(HEAT_OUTPUT_FACING, HEAT_OUTPUT_POI.get(0));
            CapabilityPosition opposingCP = CapabilityPosition.opposing((MultiblockFace)heatMBFace);
            MultiblockFace opposingMBFace = new MultiblockFace(opposingCP.side(), opposingCP.posInMultiblock());
            this.boilerInput = ctx.getCapabilityAt(HeatCapabilities.HEAT_CONSUMER_CAPABILITY, opposingMBFace);
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128347_("heatLevel", this.heatLevel);
            nbt.m_128405_("burnRemaining", this.burnRemaining);
            nbt.m_128405_("totalBurnTime", this.totalBurnTime);
            nbt.m_128347_("heatPerTick", this.heatPerTick);
            nbt.m_128379_("pilotLit", this.pilotLit);
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.heatLevel = nbt.m_128459_("heatLevel");
            this.burnRemaining = nbt.m_128451_("burnRemaining");
            this.totalBurnTime = nbt.m_128451_("totalBurnTime");
            this.heatPerTick = nbt.m_128459_("heatPerTick");
            this.pilotLit = nbt.m_128471_("pilotLit");
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory;
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
            nbt.m_128347_("heatLevel", this.heatLevel);
            nbt.m_128379_("pilotLit", this.pilotLit);
            nbt.m_128405_("burnRemaining", this.burnRemaining);
            nbt.m_128405_("totalBurnTime", this.totalBurnTime);
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128379_("needClientBlockUpdate", this.needClientBlockUpdate);
            this.needClientBlockUpdate = false;
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
            this.heatLevel = nbt.m_128459_("heatLevel");
            this.pilotLit = nbt.m_128471_("pilotLit");
            this.burnRemaining = nbt.m_128451_("burnRemaining");
            this.totalBurnTime = nbt.m_128451_("totalBurnTime");
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.needClientBlockUpdate = nbt.m_128471_("needClientBlockUpdate");
        }
    }

    private record HeatSourceImpl(State state) implements IHeatProvider
    {
        @Override
        public double getHeatLevel() {
            return this.state.heatLevel;
        }
    }

    private static class FuelItemHandler
    extends ITSlotwiseItemHandler {
        private final Supplier<Level> levelSupplier;

        public FuelItemHandler(Supplier<Level> levelSupplier, List<ITSlotwiseItemHandler.IOConstraint> constraints, Runnable onChanged) {
            super(constraints, onChanged);
            this.levelSupplier = levelSupplier;
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            Level l;
            if (slot != 0 || stack.m_41619_()) {
                return false;
            }
            ItemStack single = stack.m_41777_();
            single.m_41764_(1);
            Level level = l = this.levelSupplier != null ? this.levelSupplier.get() : null;
            if (l != null) {
                if (ForgeHooks.getBurnTime((ItemStack)single, (RecipeType)RecipeType.f_44108_) > 0) {
                    return true;
                }
                return BoilerSolidRecipe.findRecipe(l, single) != null;
            }
            return true;
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!simulate && !this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

