/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.logic;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.blockimpl.InitialMultiblockContext;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mctmods.immersivetechnology.common.multiblocks.helper.ITDisplayContext;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarMelterLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarTowerLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.shapes.SolarReflectorShape;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.common.util.solarregistry.SolarRegistry;
import mctmods.immersivetechnology.core.ITClientConfig;
import mctmods.immersivetechnology.core.lib.ITSound;
import mctmods.immersivetechnology.core.registration.ITSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SolarReflectorLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final float BASE_FREQ = 2.09f;
    public static final float DANCE_DURATION = 63.0f;
    private static final List<PoIJSONSchema> RAW_POIS = ImmutableList.copyOf((Object[])SolarReflectorShape.DATA.pointsOfInterest);
    public static BlockPos DANCE_SOUND_POI = SolarReflectorLogic.getPosList("sound").get(0);
    public static BlockPos LINK_POI = SolarReflectorLogic.getPosList("link").get(0);
    public static BlockPos SUN_POI = SolarReflectorLogic.getPosList("sun").get(0);
    public static BlockPos BEAM_POI = SolarReflectorLogic.getPosList("beam").get(0);

    private static List<BlockPos> getPosList(String name) {
        return (List)RAW_POIS.stream().filter(poi -> poi.name.equals(name)).map(poi -> new BlockPos(poi.pos[0], poi.pos[1], poi.pos[2])).collect(ImmutableList.toImmutableList());
    }

    public void tickClient(IMultiblockContext<State> ctx) {
        float deltaTilt;
        float delta;
        float targetRot;
        State state = (State)ctx.getState();
        ++state.formedTicks;
        boolean isDisabled = ITClientConfig.disableReflectorDance;
        boolean isLoop = ITClientConfig.loopReflectorDance;
        long gameTime = ctx.getLevel().getRawLevel().m_46467_();
        int targetPhase = state.isMirrorTaken ? -4 : (isDisabled ? -4 : (state.pendingTick > 0L && gameTime < state.pendingTick ? -5 : (state.danceStartTick > 0L ? (isLoop ? -2 : state.globalAnimationPhase) : -4)));
        if (!state.isMirrorTaken && state.animationPhase != targetPhase) {
            int oldPhase = state.animationPhase;
            state.animationPhase = targetPhase;
            if (state.animationPhase == -2 && oldPhase != -3) {
                state.entryDanceTick = gameTime;
                state.entry_supportRotation = state.animation_supportRotation;
                state.entry_mirrorTilt = state.animation_mirrorTilt;
                state.baseRotation = (state.entry_supportRotation % 360.0f + 360.0f) % 360.0f;
                state.danceSoundStarted = false;
            } else if (state.animationPhase == -4) {
                state.baseRotation = (state.animation_supportRotation % 360.0f + 360.0f) % 360.0f;
            }
        }
        if (state.danceStartTick != state.prevDanceStartTick) {
            state.prevDanceStartTick = state.danceStartTick;
            ++state.danceSoundId;
        }
        if (state.isMirrorTaken != state.prev_isMirrorTaken || !state.towerCollectorPosition.equals((Object)state.prev_towerCollectorPosition)) {
            boolean taken = state.isMirrorTaken;
            BlockPos position = state.towerCollectorPosition;
            if (taken) {
                targetRot = state.computeTargetSupportRotation();
                delta = targetRot - state.animation_supportRotation;
                delta = (delta + 540.0f) % 360.0f - 180.0f;
                state.start_supportRotation = state.animation_supportRotation;
                state.delta_supportRotation = delta;
                state.start_mirrorTilt = state.animation_mirrorTilt;
                state.delta_mirrorTilt = 0.0f;
                state.animation_maxTicks = 60;
                state.animationTicks = 60;
                state.animationPhase = 0;
            } else if (targetPhase == -4) {
                float deltaRot = 0.0f;
                deltaTilt = 0.0f - state.animation_mirrorTilt;
                state.start_supportRotation = state.animation_supportRotation;
                state.delta_supportRotation = deltaRot;
                state.start_mirrorTilt = state.animation_mirrorTilt;
                state.delta_mirrorTilt = deltaTilt;
                state.animation_maxTicks = 60;
                state.animationTicks = 60;
                state.animationPhase = -1;
            }
            state.prev_isMirrorTaken = taken;
            state.prev_towerCollectorPosition = position;
        }
        if (state.animationTicks > 0) {
            float prog = (float)(state.animation_maxTicks - state.animationTicks) / (float)state.animation_maxTicks;
            float eased = Mth.m_14089_((float)(prog * (float)Math.PI)) * -0.5f + 0.5f;
            state.animation_supportRotation = state.start_supportRotation + state.delta_supportRotation * eased;
            state.animation_mirrorTilt = state.start_mirrorTilt + state.delta_mirrorTilt * eased;
            --state.animationTicks;
            if (state.animationTicks == 0) {
                if (state.animationPhase == -1) {
                    if (state.isMirrorTaken) {
                        targetRot = state.computeTargetSupportRotation();
                        delta = targetRot - state.animation_supportRotation;
                        delta = (delta + 540.0f) % 360.0f - 180.0f;
                        state.start_supportRotation = state.animation_supportRotation;
                        state.delta_supportRotation = delta;
                        state.start_mirrorTilt = state.animation_mirrorTilt;
                        state.delta_mirrorTilt = 0.0f;
                        state.animation_maxTicks = 60;
                        state.animationTicks = 60;
                        state.animationPhase = 0;
                    }
                } else if (state.animationPhase == 0) {
                    float targetTilt = state.computeTargetMirrorTilt();
                    deltaTilt = targetTilt - state.animation_mirrorTilt;
                    state.start_supportRotation = state.animation_supportRotation;
                    state.delta_supportRotation = 0.0f;
                    state.start_mirrorTilt = state.animation_mirrorTilt;
                    state.delta_mirrorTilt = deltaTilt;
                    state.animation_maxTicks = 60;
                    state.animationTicks = 60;
                    state.animationPhase = 1;
                } else if (state.animationPhase == 1) {
                    state.animationPhase = 2;
                }
            }
        } else if (state.animationPhase == -5) {
            state.baseRotation += 0.5f;
            state.animation_supportRotation = state.baseRotation = (state.baseRotation % 360.0f + 360.0f) % 360.0f;
            state.animation_mirrorTilt = 0.0f;
        } else if (state.animationPhase == -2 || state.animationPhase == -3) {
            float currentDancePhase = (float)(gameTime - state.danceStartTick) * 0.05f;
            if (isLoop && (currentDancePhase = (currentDancePhase % 63.0f + 63.0f) % 63.0f) < state.prevDancePhase - 0.01f) {
                ++state.danceSoundId;
                state.danceSoundStarted = false;
            }
            state.prevDancePhase = currentDancePhase;
            float fade = Mth.m_14036_((float)(currentDancePhase / 3.0f), (float)0.0f, (float)1.0f);
            if (isLoop) {
                float fadeOut = Mth.m_14036_((float)((63.0f - currentDancePhase) / 3.0f), (float)0.0f, (float)1.0f);
                fade = Math.min(fade, fadeOut);
            } else if (state.animationPhase == -3) {
                fade *= Mth.m_14036_((float)(1.0f - (currentDancePhase - 63.0f)), (float)0.0f, (float)1.0f);
            }
            double baseBeatSin = Math.sin(currentDancePhase * 2.09f);
            double doubleBeat = Math.sin((double)currentDancePhase * 4.18);
            double tripleBeat = Math.sin((double)currentDancePhase * 6.27);
            double swayCos = Math.cos((double)currentDancePhase * 1.05);
            double rotSway = Math.sin((double)currentDancePhase * 0.52) * 60.0 * (double)fade;
            double rotTwist = Math.cos((double)currentDancePhase * 2.09) * 30.0 * (double)fade;
            double rotFlair = tripleBeat * 10.0 * (double)fade;
            float target_mirrorTilt = (float)((baseBeatSin * 20.0 + doubleBeat * 10.0 + tripleBeat * 15.0 + swayCos * 25.0) * (double)fade);
            float target_supportRotation = (float)((double)state.baseRotation + rotSway + rotTwist + rotFlair);
            float entryCurrent = state.entryDanceTick < 0L ? currentDancePhase : (float)(gameTime - state.entryDanceTick) * 0.05f;
            float localFade = Mth.m_14036_((float)(entryCurrent / 3.0f), (float)0.0f, (float)1.0f);
            state.animation_mirrorTilt = state.entry_mirrorTilt * (1.0f - localFade) + target_mirrorTilt * localFade;
            state.animation_supportRotation = state.entry_supportRotation * (1.0f - localFade) + target_supportRotation * localFade;
            state.animation_mirrorTilt = Mth.m_14036_((float)state.animation_mirrorTilt, (float)-50.0f, (float)50.0f);
            if (currentDancePhase >= 0.0f) {
                state.baseRotation += (float)(0.5 + Math.abs(baseBeatSin) * 1.5 * (double)fade);
                state.baseRotation = (state.baseRotation % 360.0f + 360.0f) % 360.0f;
            }
            if (!state.isDanceSoundPlaying.getAsBoolean() && !state.danceSoundStarted) {
                long elapsed;
                long durationTicks = Math.round(1260.0f);
                if (isLoop) {
                    elapsed = (gameTime - state.danceStartTick) % durationTicks;
                    if (elapsed < 0L) {
                        elapsed += durationTicks;
                    }
                } else {
                    elapsed = gameTime - state.danceStartTick;
                }
                if (elapsed >= 0L && elapsed < 180L) {
                    Vec3 soundPos = ctx.getLevel().toAbsolute(new Vec3((double)DANCE_SOUND_POI.m_123341_() + 0.5, (double)DANCE_SOUND_POI.m_123342_() + 0.5, (double)DANCE_SOUND_POI.m_123343_() + 0.5));
                    ++state.danceSoundId;
                    int thisId = state.danceSoundId;
                    state.isDanceSoundPlaying = ITSound.startSound(() -> (state.animationPhase == -2 || state.animationPhase == -3) && state.danceSoundId == thisId, ctx.isValid(), soundPos, ITSounds.dance, isLoop, () -> {
                        float f;
                        float cdp;
                        LocalPlayer player = Minecraft.m_91087_().f_91074_;
                        if (player == null) {
                            return Float.valueOf(0.0f);
                        }
                        float attenuation = (float)Math.max(player.m_20238_(soundPos) / 32.0, 1.0);
                        long gt = 0L;
                        if (Minecraft.m_91087_().f_91073_ != null) {
                            gt = Minecraft.m_91087_().f_91073_.m_46467_();
                        }
                        if ((cdp = (float)(gt - state.danceStartTick) * 0.05f) < 0.0f) {
                            return Float.valueOf(0.0f);
                        }
                        if (isLoop) {
                            cdp = (cdp % 63.0f + 63.0f) % 63.0f;
                            float f_in = Mth.m_14036_((float)(cdp / 3.0f), (float)0.0f, (float)1.0f);
                            float f_out = Mth.m_14036_((float)((63.0f - cdp) / 3.0f), (float)0.0f, (float)1.0f);
                            f = Math.min(f_in, f_out);
                        } else {
                            if (cdp > 64.0f) {
                                return Float.valueOf(0.0f);
                            }
                            f = Mth.m_14036_((float)(cdp / 3.0f), (float)0.0f, (float)1.0f);
                            if (state.animationPhase == -3) {
                                f *= Mth.m_14036_((float)(1.0f - (cdp - 63.0f)), (float)0.0f, (float)1.0f);
                            }
                        }
                        float baseVol = 0.05f + f * 0.45f;
                        return Float.valueOf(baseVol / attenuation);
                    }, () -> Float.valueOf(1.0f));
                    state.danceSoundStarted = true;
                }
            }
        } else if (state.animationPhase == -4) {
            state.baseRotation += 0.5f;
            state.animation_supportRotation = state.baseRotation = (state.baseRotation % 360.0f + 360.0f) % 360.0f;
            state.animation_mirrorTilt = 0.0f;
        }
        if (state.isMirrorTaken && state.animationPhase == 2 && state.getSolarCollectorStrength() > 0.0) {
            Level level = ctx.getLevel().getRawLevel();
            if (level.f_46441_.m_188501_() < 0.04f) {
                Vec3 start = ctx.getLevel().toAbsolute(Vec3.m_82512_((Vec3i)BEAM_POI));
                Vec3 end = Vec3.m_82512_((Vec3i)state.getTowerCollectorPosition());
                Vec3 diff = end.m_82546_(start);
                double dist = diff.m_82553_();
                double distSq = dist * dist;
                if (distSq > 4096.0) {
                    return;
                }
                Vec3 dir = diff.m_82541_();
                double rdist = level.f_46441_.m_188500_() * dist * 0.9;
                Vec3 pos = start.m_82549_(dir.m_82490_(rdist));
                double speed = 0.08 + level.f_46441_.m_188500_() * 0.05;
                Vec3 vel = dir.m_82490_(speed);
                Vec3 perp1 = dir.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(level.f_46441_.m_188583_() * 0.005);
                Vec3 perp2 = dir.m_82537_(perp1).m_82541_().m_82490_(level.f_46441_.m_188583_() * 0.005);
                vel = vel.m_82549_(perp1).m_82549_(perp2);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void tickServer(IMultiblockContext<State> ctx) {
        block15: {
            block16: {
                block17: {
                    state = (State)ctx.getState();
                    level = ctx.getLevel().getRawLevel();
                    update = false;
                    ++state.loadTicks;
                    if (state.loadTicks > 10 && !state.initialized && !level.f_46443_) {
                        state.initialized = true;
                        SolarRegistry.registerReflector(level, state.poiPos);
                        ctx.markMasterDirty();
                        ctx.requestMasterBESync();
                    }
                    if (state.loadTicks <= 20 || !state.reAttachOnLoad || level.f_46443_) break block15;
                    state.reAttachOnLoad = false;
                    if (!level.m_46749_(state.towerCollectorPosition)) break block15;
                    be = level.m_7702_(state.towerCollectorPosition);
                    if (!(be instanceof IMultiblockBE)) break block16;
                    mbe = (IMultiblockBE)be;
                    helper = mbe.getHelper();
                    if (helper == null) break block17;
                    hstate = helper.getState();
                    isValid = false;
                    if (!(hstate instanceof SolarTowerLogic.State)) ** GOTO lbl-1000
                    towerState = (SolarTowerLogic.State)hstate;
                    if (towerState.registered) {
                        isValid = true;
                    } else if (hstate instanceof SolarMelterLogic.State) {
                        melterState = (SolarMelterLogic.State)hstate;
                        if (melterState.registered) {
                            isValid = true;
                        }
                    }
                    if (isValid) {
                        state.setTowerCollectorPosition(state.towerCollectorPosition);
                        update = true;
                    }
                }
                if (!update) {
                    state.isMirrorTaken = false;
                    state.towerCollectorPosition = state.poiPos;
                    SolarRegistry.notifyTaken(level, state.poiPos, false);
                    update = true;
                }
                break block15;
            }
            state.isMirrorTaken = false;
            state.towerCollectorPosition = state.poiPos;
            SolarRegistry.notifyTaken(level, state.poiPos, false);
            update = true;
        }
        v0 = isActive = state.isMirrorTaken != false && state.getSolarCollectorStrength() > 0.0;
        if (state.active != isActive) {
            state.active = isActive;
            update = true;
        }
        oldDanceStartTick = state.danceStartTick;
        oldPendingTick = state.pendingTick;
        oldGlobalAnimationPhase = state.globalAnimationPhase;
        if (!state.isMirrorTaken) {
            root = SolarRegistry.findRoot(level, state.poiPos);
            if (root != null) {
                gd = SolarRegistry.getGroupData(level, root);
                if (gd != null) {
                    state.danceStartTick = gd.danceStartTick;
                    state.pendingTick = gd.pendingTick;
                    state.globalAnimationPhase = gd.animationPhase;
                } else {
                    state.danceStartTick = -1L;
                    state.pendingTick = -1L;
                    state.globalAnimationPhase = -4;
                }
            }
        } else {
            state.danceStartTick = -1L;
            state.pendingTick = -1L;
            state.globalAnimationPhase = -4;
        }
        v1 = changed = state.danceStartTick != oldDanceStartTick || state.pendingTick != oldPendingTick || state.globalAnimationPhase != oldGlobalAnimationPhase;
        if (changed || update) {
            ctx.markMasterDirty();
            ctx.requestMasterBESync();
        }
        if (!state.isMirrorTaken) {
            SolarRegistry.updateDance(level);
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        return LazyOptional.empty();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType shapeType) {
        return SolarReflectorShape.GETTER;
    }

    public State createInitialState(IInitialMultiblockContext<State> context) {
        return new State(context);
    }

    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        Level level = state.levelSupplier.get();
        if (level != null && !level.f_46443_) {
            SolarRegistry.unregisterReflector(level, state.poiPos);
        }
    }

    public static class State
    implements IMultiblockState,
    ITDisplayContext {
        public boolean isMirrorTaken;
        private BlockPos towerCollectorPosition;
        public float animation_supportRotation;
        public float animation_mirrorTilt;
        public int animationTicks = 0;
        public int animationPhase = 0;
        public float baseRotation;
        private final Direction facing;
        public final BlockPos poiPos;
        public BlockPos sunPos;
        private final Supplier<Level> levelSupplier;
        private final Runnable markDirty;
        private final Runnable sync;
        public boolean initialized = false;
        public boolean active = false;
        public BooleanSupplier isDanceSoundPlaying = () -> false;
        private transient int danceSoundId = 0;
        public transient int formedTicks = 0;
        private transient float start_supportRotation;
        private transient float delta_supportRotation;
        private transient float start_mirrorTilt;
        private transient float delta_mirrorTilt;
        private transient int animation_maxTicks;
        private transient boolean prev_isMirrorTaken;
        private transient BlockPos prev_towerCollectorPosition;
        private transient long danceStartTick = -1L;
        private transient long pendingTick = -1L;
        private transient int globalAnimationPhase = -4;
        private transient long entryDanceTick = -1L;
        private transient float entry_supportRotation;
        private transient float entry_mirrorTilt;
        private transient float prevDancePhase = 0.0f;
        private transient long prevDanceStartTick = -1L;
        private transient boolean danceSoundStarted = false;
        private int loadTicks = 0;
        private boolean reAttachOnLoad = false;

        public State(IInitialMultiblockContext<State> context) {
            InitialMultiblockContext initialContext = (InitialMultiblockContext)context;
            MultiblockOrientation orientation = initialContext.orientation();
            this.facing = orientation.front();
            BlockPos masterOffset = initialContext.masterOffset();
            BlockPos masterPos = initialContext.masterBE().m_58899_();
            BlockPos origin = masterPos.m_121996_((Vec3i)orientation.getAbsoluteOffset(masterOffset));
            this.poiPos = origin.m_121955_((Vec3i)orientation.getAbsoluteOffset(LINK_POI));
            this.sunPos = origin.m_121955_((Vec3i)orientation.getAbsoluteOffset(SUN_POI));
            this.towerCollectorPosition = this.poiPos;
            this.levelSupplier = context.levelSupplier();
            this.markDirty = context.getMarkDirtyRunnable();
            this.sync = context.getSyncRunnable();
            this.animation_supportRotation = 0.0f;
            this.animation_mirrorTilt = 0.0f;
            this.isMirrorTaken = false;
            this.baseRotation = 0.0f;
            this.prev_isMirrorTaken = false;
            this.prev_towerCollectorPosition = this.towerCollectorPosition;
        }

        private float computeTargetSupportRotation() {
            int dx = this.towerCollectorPosition.m_123341_() - this.poiPos.m_123341_();
            int dz = this.towerCollectorPosition.m_123343_() - this.poiPos.m_123343_();
            float absoluteYaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
            absoluteYaw = (absoluteYaw + 360.0f) % 360.0f;
            float mbRotation = (float)this.facing.m_122416_() * 90.0f;
            float target = mbRotation - absoluteYaw + 180.0f;
            return (target + 720.0f) % 360.0f;
        }

        private float computeTargetMirrorTilt() {
            int dx = this.towerCollectorPosition.m_123341_() - this.poiPos.m_123341_();
            int dy = this.towerCollectorPosition.m_123342_() - this.poiPos.m_123342_();
            int dz = this.towerCollectorPosition.m_123343_() - this.poiPos.m_123343_();
            double horizontal = Math.sqrt(dx * dx + dz * dz);
            double dist = Math.sqrt(horizontal * horizontal + (double)(dy * dy));
            if (dist == 0.0) {
                return 0.0f;
            }
            double i_x = 0.0;
            double u_x = (double)dx / dist;
            double diff_x = i_x - u_x;
            double i_y = -1.0;
            double u_y = (double)dy / dist;
            double diff_y = i_y - u_y;
            double i_z = 0.0;
            double u_z = (double)dz / dist;
            double diff_z = i_z - u_z;
            double len = Math.sqrt(diff_x * diff_x + diff_y * diff_y + diff_z * diff_z);
            if (len == 0.0) {
                return 0.0f;
            }
            double n_y = diff_y / len;
            if (n_y < 0.0) {
                n_y = -n_y;
            }
            double normal_elev_rad = Math.asin(n_y);
            return (float)(90.0 - Math.toDegrees(normal_elev_rad));
        }

        public BlockPos getTowerCollectorPosition() {
            return this.towerCollectorPosition;
        }

        public double getSolarCollectorStrength() {
            Level level = this.levelSupplier.get();
            if (level == null) {
                return 0.0;
            }
            int numClear = 0;
            Direction right = this.facing.m_122427_();
            Direction back = this.facing.m_122424_();
            BlockPos baseCheck = this.sunPos.m_7494_();
            for (int l = -1; l < 2; ++l) {
                for (int w = -1; w < 2; ++w) {
                    BlockPos checkPos = baseCheck.m_5484_(back, l).m_5484_(right, w);
                    if (!level.m_45527_(checkPos)) continue;
                    ++numClear;
                }
            }
            return (double)numClear / 9.0;
        }

        public boolean setTowerCollectorPosition(BlockPos position) {
            int dz;
            int dx = position.m_123341_() - this.poiPos.m_123341_();
            double horizontal = Math.sqrt(dx * dx + (dz = position.m_123343_() - this.poiPos.m_123343_()) * dz);
            if (horizontal == 0.0) {
                return false;
            }
            if (!this.isMirrorTaken) {
                this.towerCollectorPosition = position;
                this.isMirrorTaken = true;
                Level level = this.levelSupplier.get();
                if (level != null) {
                    SolarRegistry.notifyTaken(level, this.poiPos, true);
                }
                this.markDirty.run();
                this.sync.run();
            }
            return this.towerCollectorPosition.equals((Object)position);
        }

        public void detachTower(BlockPos position) {
            if (this.towerCollectorPosition.equals((Object)position)) {
                this.isMirrorTaken = false;
                this.towerCollectorPosition = this.poiPos;
                Level level = this.levelSupplier.get();
                if (level != null) {
                    SolarRegistry.notifyTaken(level, this.poiPos, false);
                }
                this.markDirty.run();
                this.sync.run();
            }
        }

        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128379_("isMirrorTaken", this.isMirrorTaken);
            nbt.m_128356_("towerCollectorPosition", this.towerCollectorPosition.m_121878_());
            nbt.m_128379_("active", this.active);
        }

        public void readSaveNBT(CompoundTag nbt) {
            this.isMirrorTaken = nbt.m_128471_("isMirrorTaken");
            this.towerCollectorPosition = BlockPos.m_122022_((long)nbt.m_128454_("towerCollectorPosition"));
            this.active = nbt.m_128471_("active");
            this.reAttachOnLoad = nbt.m_128471_("isMirrorTaken");
            this.initialized = false;
            Level level = this.levelSupplier.get();
            if (level != null && !level.f_46443_) {
                SolarRegistry.registerReflector(level, this.poiPos);
            }
        }

        public void writeSyncNBT(CompoundTag nbt) {
            CompoundTag display = new CompoundTag();
            this.writeDisplaySyncNBT(display);
            nbt.m_128365_("display", (Tag)display);
        }

        public void readSyncNBT(CompoundTag nbt) {
            if (nbt.m_128425_("display", 10)) {
                this.readDisplaySyncNBT(nbt.m_128469_("display"));
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return null;
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return null;
        }

        @Override
        public void writeDisplaySyncNBT(CompoundTag nbt) {
            nbt.m_128379_("isMirrorTaken", this.isMirrorTaken);
            nbt.m_128356_("towerCollectorPosition", this.towerCollectorPosition.m_121878_());
            nbt.m_128356_("danceStartTick", this.danceStartTick);
            nbt.m_128356_("pendingTick", this.pendingTick);
            nbt.m_128405_("globalAnimationPhase", this.globalAnimationPhase);
        }

        @Override
        public void readDisplaySyncNBT(CompoundTag nbt) {
            this.isMirrorTaken = nbt.m_128471_("isMirrorTaken");
            this.towerCollectorPosition = BlockPos.m_122022_((long)nbt.m_128454_("towerCollectorPosition"));
            this.danceStartTick = nbt.m_128454_("danceStartTick");
            this.pendingTick = nbt.m_128454_("pendingTick");
            this.globalAnimationPhase = nbt.m_128451_("globalAnimationPhase");
        }
    }
}

