/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.process;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.BoilerLiquidLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerLiquidRecipe;
import mctmods.immersivetechnology.core.registration.ITSounds;
import mctmods.immersivetechnology.core.registration.ITTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class BoilerLiquidProcess
implements IMultiblockComponent<BoilerLiquidLogic.State> {
    public InteractionResult click(IMultiblockContext<BoilerLiquidLogic.State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        Direction poiSide;
        if (!BoilerLiquidLogic.IGNITION_POI.contains(posInMultiblock)) {
            return InteractionResult.PASS;
        }
        Direction hitDir = absoluteHit.m_82434_();
        if (BoilerLiquidLogic.IGNITION_FACING != null && hitDir != (poiSide = ctx.getLevel().toAbsolute(BoilerLiquidLogic.IGNITION_FACING))) {
            return InteractionResult.PASS;
        }
        ItemStack held = player.m_21120_(hand);
        if (!held.m_204117_(ITTags.igniters)) {
            return InteractionResult.PASS;
        }
        BoilerLiquidLogic.State state = (BoilerLiquidLogic.State)ctx.getState();
        if (state.pilotLit) {
            return InteractionResult.PASS;
        }
        Level level = ctx.getLevel().getRawLevel();
        if (state.tanks.input1().getFluidAmount() <= 0 || BoilerLiquidRecipe.findRecipe(level, state.tanks.input1().getFluid()) == null) {
            return InteractionResult.PASS;
        }
        if (isClient) {
            return InteractionResult.SUCCESS;
        }
        state.pilotLit = true;
        state.heatLevel = 20.0;
        level.m_5594_(null, ctx.getLevel().toAbsolute(BoilerLiquidLogic.IGNITION_POI.get(0)), (SoundEvent)ITSounds.gasIgnite.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        if (held.m_204117_(ITTags.igniters_consume)) {
            held.m_41774_(1);
        } else if (held.m_41776_() > 0) {
            held.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        ctx.markMasterDirty();
        ctx.requestMasterBESync();
        return InteractionResult.SUCCESS;
    }
}

