/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.process;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import java.util.function.BiFunction;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.DistillerLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.DistillerRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class DistillerProcess
extends MultiblockProcessInMachine<DistillerRecipe> {
    public DistillerProcess(DistillerRecipe recipe) {
        super((MultiblockRecipe)recipe, new int[0]);
        this.setInputTanks(new int[]{0});
    }

    public DistillerProcess(BiFunction<Level, ResourceLocation, DistillerRecipe> getRecipe, CompoundTag data) {
        super(getRecipe, data);
        this.setInputTanks(new int[]{0});
    }

    public void doProcessTick(ProcessContext.ProcessContextInMachine<DistillerRecipe> context, IMultiblockLevel level) {
        MultiblockProcess.LevelDependentData levelData = this.getLevelData(level.getRawLevel());
        if (levelData.recipe() == null) {
            this.clearProcess = true;
            return;
        }
        if (this.processTick == 0) {
            int amount;
            IFluidTank inputTank = context.getInternalTanks()[0];
            FluidStack drained = inputTank.drain(amount = ((DistillerRecipe)levelData.recipe()).input.getAmount(), IFluidHandler.FluidAction.SIMULATE);
            if (drained.getAmount() < amount || !((DistillerRecipe)levelData.recipe()).input.testIgnoringAmount(drained)) {
                this.clearProcess = true;
                return;
            }
            inputTank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
        }
        super.doProcessTick(context, level);
    }

    public boolean canProcess(ProcessContext.ProcessContextInMachine<DistillerRecipe> context, Level level) {
        MultiblockProcess.LevelDependentData levelData = this.getLevelData(level);
        if (levelData.recipe() == null) {
            return true;
        }
        return context.getEnergy().extractEnergy(levelData.energyPerTick(), true) == levelData.energyPerTick();
    }

    protected void processFinish(ProcessContext.ProcessContextInMachine<DistillerRecipe> context, IMultiblockLevel level) {
        super.processFinish(context, level);
        DistillerRecipe recipe = (DistillerRecipe)this.getRecipe(level.getRawLevel());
        if (recipe != null) {
            if (recipe.fluidOutput != null && !recipe.fluidOutput.isEmpty()) {
                ((DistillerLogic.State)context).getTanks().output().fill(recipe.fluidOutput.copy(), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!recipe.itemOutput.m_41619_() && level.getRawLevel().f_46441_.m_188501_() < recipe.chance) {
                IItemHandlerModifiable inv = context.getInventory();
                ItemStack salt = recipe.itemOutput.m_41777_();
                ItemStack current = inv.getStackInSlot(4);
                if (current.m_41619_()) {
                    inv.setStackInSlot(4, salt);
                } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)current, (ItemStack)salt) && current.m_41613_() + salt.m_41613_() <= current.m_41741_()) {
                    current.m_41769_(salt.m_41613_());
                    inv.setStackInSlot(4, current);
                }
            }
        }
    }
}

