/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.multiblocks.metal.recipe.serializer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.BoilerTankRecipe;
import mctmods.immersivetechnology.core.registration.ITMultiblockProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoilerTankRecipeSerializer
extends IERecipeSerializer<BoilerTankRecipe> {
    public ItemStack getIcon() {
        return ITMultiblockProvider.BOILER_TANK.iconStack();
    }

    public BoilerTankRecipe readFromJson(ResourceLocation recipeID, JsonObject json, ICondition.IContext iContext) {
        FluidTagInput input = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
        FluidStack output = ApiUtils.jsonDeserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        int time = GsonHelper.m_13824_((JsonObject)json, (String)"time", (int)1);
        return new BoilerTankRecipe(recipeID, input, output, time);
    }

    @Nullable
    public BoilerTankRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        FluidTagInput input = FluidTagInput.read((FriendlyByteBuf)buffer);
        FluidStack output = buffer.readFluidStack();
        int time = buffer.readInt();
        return new BoilerTankRecipe(recipeId, input, output, time);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, BoilerTankRecipe recipe) {
        recipe.input.write(buffer);
        buffer.writeFluidStack(recipe.output);
        buffer.writeInt(recipe.getTotalProcessTime());
    }
}

