/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.inventory;

import java.util.Objects;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.common.util.inventory.IITInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class ITInventoryHandler
implements IItemHandlerModifiable {
    int slots;
    IITInventory inv;
    int slotOffset;
    boolean[] canInsert;
    boolean[] canExtract;

    public ITInventoryHandler(int slots, IITInventory inventory, int slotOffset, boolean[] canInsert, boolean[] canExtract) {
        this.slots = slots;
        this.inv = inventory;
        this.slotOffset = slotOffset;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
    }

    public int getSlots() {
        return this.slots;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)Objects.requireNonNull(this.inv.getInventory()).get(this.slotOffset + slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.canInsert[slot] && !stack.m_41619_()) {
            if (!this.inv.isStackValid(this.slotOffset + slot, stack)) {
                return stack;
            }
            int offsetSlot = this.slotOffset + slot;
            ItemStack currentStack = (ItemStack)Objects.requireNonNull(this.inv.getInventory()).get(offsetSlot);
            if (currentStack.m_41619_()) {
                int accepted = Math.min(stack.m_41741_(), this.inv.getSlotLimit(offsetSlot));
                if (accepted < stack.m_41613_()) {
                    stack = stack.m_41777_();
                    if (!simulate) {
                        this.inv.getInventory().set(offsetSlot, (Object)stack.m_41620_(accepted));
                        this.inv.doGraphicalUpdates();
                    } else {
                        stack.m_41774_(accepted);
                    }
                    return stack;
                }
                if (!simulate) {
                    this.inv.getInventory().set(offsetSlot, (Object)stack.m_41777_());
                    this.inv.doGraphicalUpdates();
                }
                return ItemStack.f_41583_;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentStack)) {
                return stack;
            }
            int accepted = Math.min(stack.m_41741_(), this.inv.getSlotLimit(offsetSlot)) - currentStack.m_41613_();
            if (accepted < stack.m_41613_()) {
                stack = stack.m_41777_();
                if (!simulate) {
                    ItemStack newStack = stack.m_41620_(accepted);
                    newStack.m_41769_(currentStack.m_41613_());
                    this.inv.getInventory().set(offsetSlot, (Object)newStack);
                    this.inv.doGraphicalUpdates();
                } else {
                    stack.m_41774_(accepted);
                }
                return stack;
            }
            if (!simulate) {
                ItemStack newStack = stack.m_41777_();
                newStack.m_41769_(currentStack.m_41613_());
                this.inv.getInventory().set(offsetSlot, (Object)newStack);
                this.inv.doGraphicalUpdates();
            }
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canExtract[slot] && amount != 0) {
            int offsetSlot = this.slotOffset + slot;
            ItemStack currentStack = (ItemStack)Objects.requireNonNull(this.inv.getInventory()).get(offsetSlot);
            if (currentStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int extracted = Math.min(currentStack.m_41613_(), amount);
            ItemStack copy = currentStack.m_41777_();
            copy.m_41764_(extracted);
            if (!simulate) {
                if (extracted < currentStack.m_41613_()) {
                    currentStack.m_41774_(extracted);
                } else {
                    currentStack = ItemStack.f_41583_;
                }
                this.inv.getInventory().set(offsetSlot, (Object)currentStack);
                this.inv.doGraphicalUpdates();
            }
            return copy;
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.canInsert[slot] && this.inv.isStackValid(slot, stack);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        Objects.requireNonNull(this.inv.getInventory()).set(this.slotOffset + slot, (Object)stack);
        this.inv.doGraphicalUpdates();
    }
}

