/*
 * Decompiled with CFR 0.152.
 */
package magicalpsirevival;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.locating.IModFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="magipsi")
public class MagicalPsiRevival {
    public static final String MODID = "magipsi";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"magipsi");

    public MagicalPsiRevival(IEventBus eventBus) {
        eventBus.addListener(this::addPackFinders);
    }

    private void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            this.addPsiOverridesPack(event);
        }
    }

    private void addPsiOverridesPack(AddPackFindersEvent event) {
        IModFile modFile = ModList.get().getModFileById(MODID).getFile();
        Path path = modFile.findResource(new String[]{"psi_overrides"});
        PackLocationInfo packLocationInfo = new PackLocationInfo("builtin/psi_overrides", (Component)Component.literal((String)"Magical Psi Revival - Psi Overrides"), PackSource.BUILT_IN, Optional.empty());
        PathPackResources packResources = new PathPackResources(packLocationInfo, path);
        LOGGER.info("Adding Psi Overrides Pack from {}", (Object)path.getFileName());
        event.addRepositorySource(arg_0 -> MagicalPsiRevival.lambda$addPsiOverridesPack$0(packLocationInfo, (PackResources)packResources, path, arg_0));
    }

    private static /* synthetic */ void lambda$addPsiOverridesPack$0(PackLocationInfo packLocationInfo, PackResources packResources, Path path, Consumer consumer) {
        Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)new SinglePackResourceResourcesSupplier(packResources), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, true));
        if (pack != null) {
            consumer.accept(pack);
        } else {
            LOGGER.error("Failed to create pack for Psi Overrides from {}", (Object)path.getFileName());
        }
    }

    private record SinglePackResourceResourcesSupplier(PackResources packResources) implements Pack.ResourcesSupplier
    {
        public PackResources openPrimary(PackLocationInfo location) {
            return this.packResources();
        }

        public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
            return this.packResources();
        }
    }
}

