/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client.models;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class WingEntityModel<T extends LivingEntity>
extends AgeableListModel<T> {
    public final ModelPart rightWing;
    public final ModelPart leftWing;
    public State state = State.IDLE;

    public WingEntityModel(ModelPart root) {
        this.rightWing = root.m_171324_("rightWing");
        this.leftWing = root.m_171324_("leftWing");
    }

    public static MeshDefinition getModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("rightWing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        modelPartData.m_171599_("leftWing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        return modelData;
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.state = State.IDLE;
        float a = 0.125f;
        float b = 0.1f;
        float k = 0.4f;
        float l = -0.5f;
        float m = -1.0f;
        float n = 0.0f;
        if (entity.m_21255_()) {
            this.state = State.FLYING;
            float o = 1.0f;
            Vec3 vec3d = entity.m_20184_();
            if (vec3d.f_82480_ < 0.0) {
                Vec3 vec3d2 = vec3d.m_82541_();
                o = 1.0f - (float)Math.pow(-vec3d2.f_82480_, 1.5);
            }
            k = o * 0.35f + (1.0f - o) * k;
            l = o * -1.6f + (0.3f - o) * l;
            if (((LivingEntity)entity).f_20902_ > 0.0f) {
                a = 0.4f;
                b = 1.0f;
            }
        } else if (entity.m_6047_()) {
            this.state = State.CROUCHING;
            k = 0.7f;
            m = 0.0f;
            n = 0.09f;
        }
        k += Mth.m_14031_((float)((float)((LivingEntity)entity).f_19797_ * a)) * b;
        this.leftWing.f_104200_ = 7.0f;
        this.leftWing.f_104201_ = m;
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            player.f_108542_ += (k - player.f_108542_) * 0.1f;
            player.f_108543_ += (n - player.f_108543_) * 0.1f;
            player.f_108544_ += (l - player.f_108544_) * 0.1f;
            this.leftWing.f_104203_ = player.f_108542_;
            this.leftWing.f_104204_ = player.f_108543_;
            this.leftWing.f_104205_ = player.f_108544_;
        } else {
            this.leftWing.f_104203_ = k;
            this.leftWing.f_104205_ = l;
            this.leftWing.f_104204_ = n;
        }
        this.rightWing.f_104200_ = -this.leftWing.f_104200_;
        this.rightWing.f_104204_ = -this.leftWing.f_104204_;
        this.rightWing.f_104201_ = this.leftWing.f_104201_;
        this.rightWing.f_104203_ = this.leftWing.f_104203_;
        this.rightWing.f_104205_ = -this.leftWing.f_104205_;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.rightWing, (Object)this.leftWing);
    }

    public static enum State {
        IDLE,
        CROUCHING,
        FLYING;

    }
}

