/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.util;

import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.api.SlowFallingEntity;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.init.IcarusDimensionTypeTags;
import dev.cammiescorner.icarus.init.IcarusItemTags;
import dev.cammiescorner.icarus.init.IcarusStatusEffects;
import dev.cammiescorner.icarus.item.WingItem;
import dev.cammiescorner.icarus.network.s2c.SyncConfigValuesPacket;
import dev.cammiescorner.icarus.util.ServerPlayerFallbackValues;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class IcarusHelper {
    @ApiStatus.Internal
    public static Predicate<LivingEntity> hasWings = entity -> false;
    @ApiStatus.Internal
    public static Function<LivingEntity, ItemStack> getEquippedWings = entity -> ItemStack.f_41583_;
    @ApiStatus.Internal
    public static BiPredicate<LivingEntity, ItemStack> equipFunc = (entity, stack) -> false;
    @ApiStatus.Internal
    public static IcarusPlayerValues fallbackValues = new ServerPlayerFallbackValues();

    public static boolean onFallFlyingTick(LivingEntity entity, @Nullable ItemStack wings, boolean tick) {
        Player player;
        WingItem wingItem;
        Item message2;
        IcarusPlayerValues cfg = IcarusHelper.getConfigValues(entity);
        Level level = entity.m_9236_();
        if (!level.m_5776_() && (level.m_204156_().m_203656_(IcarusDimensionTypeTags.NO_FLYING_ALLOWED) || level.m_9598_().m_175515_(Registries.f_256862_).m_203636_(Registries.m_257452_((ResourceKey)level.m_46472_())).map(stemHolder -> stemHolder.m_203656_(cfg.noFlyingAllowedInLevels())).orElse(false).booleanValue())) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)entity;
                IcarusHelper.stopFlying((Player)player2);
                player2.m_240418_((Component)Component.m_237115_((String)"message.icarus.status.no_fly.dimension").m_130940_(ChatFormatting.RED), true);
            }
            return false;
        }
        if (entity.m_21023_(IcarusStatusEffects.FLIGHTLESS.get())) {
            if (entity instanceof Player) {
                Player player3 = (Player)entity;
                IcarusHelper.stopFlying(player3);
                MutableComponent message2 = Component.m_237115_((String)"message.icarus.status.no_fly.status_effect").m_130940_(ChatFormatting.BLUE);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    serverPlayer.m_240418_((Component)message2, true);
                } else {
                    IcarusClient.sendActionbarMessage(player3, (Component)message2);
                }
            }
            return false;
        }
        if (!(wings == null || (message2 = wings.m_41720_()) instanceof WingItem && (wingItem = (WingItem)message2).isUsable(entity, wings))) {
            if (entity instanceof Player) {
                player = (Player)entity;
                IcarusHelper.stopFlying(player);
            }
            return false;
        }
        if (tick) {
            Player player4;
            if (cfg.canSlowFall() && entity.m_6144_() || entity.m_5842_()) {
                if (entity instanceof Player) {
                    player4 = (Player)entity;
                    IcarusHelper.stopFlying(player4);
                }
                return false;
            }
            if (!(wings != null && wings.m_204117_(IcarusItemTags.FREE_FLIGHT) || !(entity instanceof Player) || (player4 = (Player)entity).m_7500_())) {
                player4.m_36324_().m_38703_(cfg.exhaustionAmount());
                if ((float)player4.m_36324_().m_38702_() < cfg.requiredFoodAmount()) {
                    IcarusHelper.stopFlying(player4);
                    message2 = Component.m_237115_((String)"message.icarus.status.no_fly.hunger").m_130940_(ChatFormatting.BLUE);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        serverPlayer.m_240418_((Component)message2, true);
                    } else {
                        IcarusClient.sendActionbarMessage(player4, (Component)message2);
                    }
                    return false;
                }
            }
            if (wings != null && (message2 = wings.m_41720_()) instanceof WingItem && !(wingItem = (WingItem)message2).onFlightTick(entity, wings, entity.m_21256_() + 1)) {
                if (entity instanceof Player) {
                    player = (Player)entity;
                    IcarusHelper.stopFlying(player);
                }
                return false;
            }
        }
        return true;
    }

    public static boolean hasWings(LivingEntity entity) {
        return hasWings.test(entity);
    }

    @Nullable
    public static ItemStack getEquippedWings(LivingEntity entity) {
        return getEquippedWings.apply(entity);
    }

    public static IcarusPlayerValues getConfigValues(LivingEntity entity) {
        return fallbackValues;
    }

    public static void onPlayerTick(Player player) {
        if (((SlowFallingEntity)player).icarus$isSlowFalling()) {
            player.f_19789_ = 0.0f;
            if (player.m_20096_() || player.m_20069_()) {
                ((SlowFallingEntity)player).icarus$setSlowFalling(false);
            } else {
                Vec3 move = player.m_20184_();
                player.m_20334_(move.m_7096_(), -0.4, move.m_7094_());
            }
        }
    }

    public static void stopFlying(Player player) {
        ((SlowFallingEntity)player).icarus$setSlowFalling(true);
        if (player.m_146909_() < -90.0f || player.m_146909_() > 90.0f) {
            float offset = (player.m_146909_() < -90.0f ? player.m_146909_() + 180.0f : player.m_146909_() - 180.0f) * 2.0f;
            player.m_146926_((player.m_146909_() < -90.0f ? 180.0f + offset : -180.0f - offset) + player.m_146909_());
            player.m_146922_(180.0f + player.m_146908_());
        }
    }

    public static void onServerPlayerJoin(ServerPlayer player) {
        SyncConfigValuesPacket.send(player);
    }
}

