/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client;

import com.google.auto.service.AutoService;
import com.google.common.base.MoreObjects;
import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.client.IcarusModels;
import dev.cammiescorner.icarus.client.models.DiscordsWingsModel;
import dev.cammiescorner.icarus.client.models.FeatheredWingsModel;
import dev.cammiescorner.icarus.client.models.FlandresWingsModel;
import dev.cammiescorner.icarus.client.models.LeatherWingsModel;
import dev.cammiescorner.icarus.client.models.LightWingsModel;
import dev.cammiescorner.icarus.client.models.ZanzasWingsModel;
import dev.cammiescorner.icarus.init.IcarusItemTags;
import dev.cammiescorner.icarus.util.IcarusHelper;
import dev.upcraft.sparkweave.api.client.event.RegisterLayerDefinitionsEvent;
import dev.upcraft.sparkweave.api.entrypoint.ClientEntryPoint;
import dev.upcraft.sparkweave.api.event.EntityTickEvents;
import dev.upcraft.sparkweave.api.platform.ModContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

@AutoService(value={ClientEntryPoint.class})
public class IcarusClient
implements ClientEntryPoint {
    private static final List<Predicate<LivingEntity>> renderPredicates = new ArrayList<Predicate<LivingEntity>>();

    public void onInitializeClient(ModContainer mod) {
        EntityTickEvents.startTick(AbstractClientPlayer.class).register(IcarusClient::onPlayerTick);
        RegisterLayerDefinitionsEvent.EVENT.register(event -> {
            event.registerModelLayers(IcarusModels.FEATHERED, FeatheredWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.LEATHER, LeatherWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.LIGHT, LightWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.FLANDRE, FlandresWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.DISCORD, DiscordsWingsModel::getLayerDefinition);
            event.registerModelLayers(IcarusModels.ZANZA, ZanzasWingsModel::getLayerDefinition);
        });
    }

    public static boolean onPlayerTick(AbstractClientPlayer player, Level level) {
        if (player.isFallFlying() && IcarusHelper.hasWings((LivingEntity)player) && player.zza > 0.0f) {
            ItemStack wings;
            IcarusPlayerValues cfg = IcarusHelper.getConfigValues((LivingEntity)player);
            Vec3 rotation = player.getLookAngle();
            Vec3 velocity = player.getDeltaMovement();
            float upwardsAngleOfAttack = Mth.degreesDifferenceAbs((float)player.getXRot(), (float)-90.0f);
            float speed = cfg.wingsSpeed() * (upwardsAngleOfAttack <= 15.0f ? 2.75f : 1.0f);
            if (cfg.armorSlows() && (wings = IcarusHelper.getEquippedWings.apply((LivingEntity)player)) != null && !wings.isEmpty() && !wings.is(IcarusItemTags.BYPASSES_ARMOR_SLOWDOWN)) {
                speed /= Math.max(1.0f, (float)player.getArmorValue() / 30.0f * cfg.maxSlowedMultiplier());
            }
            player.setDeltaMovement(velocity.add(rotation.x * (double)speed + (rotation.x * 1.5 - velocity.x) * (double)speed, rotation.y * (double)speed + (rotation.y * 1.5 - velocity.y) * (double)speed, rotation.z * (double)speed + (rotation.z * 1.5 - velocity.z) * (double)speed));
        }
        return false;
    }

    @ApiStatus.Internal
    public static ItemStack getWingsForRendering(LivingEntity entity) {
        return (ItemStack)MoreObjects.firstNonNull((Object)IcarusHelper.getEquippedWings.apply(entity), (Object)ItemStack.EMPTY);
    }

    @ApiStatus.Internal
    public static void addRenderPredicate(Predicate<LivingEntity> predicate) {
        renderPredicates.add(predicate);
    }

    public static boolean shouldRenderWings(LivingEntity entity) {
        if (!renderPredicates.isEmpty()) {
            for (Predicate<LivingEntity> predicate : renderPredicates) {
                if (predicate.test(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public static void sendActionbarMessage(Player player, Component message) {
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            localPlayer.displayClientMessage(message, true);
        }
    }
}

