package dev.cammiescorner.icarus.fabric.entrypoints;

import dev.cammiescorner.icarus.Icarus;
import dev.cammiescorner.icarus.client.IcarusModels;
import dev.cammiescorner.icarus.client.models.*;
import dev.cammiescorner.icarus.client.renderers.WingsLayer;
import dev.cammiescorner.icarus.item.WingItem;
import dev.cammiescorner.icarus.util.ColorHelper;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_7923;

public class Client implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        EntityModelLayerRegistry.registerModelLayer(IcarusModels.FEATHERED, FeatheredWingsModel::getLayerDefinition);
        EntityModelLayerRegistry.registerModelLayer(IcarusModels.LEATHER, LeatherWingsModel::getLayerDefinition);
        EntityModelLayerRegistry.registerModelLayer(IcarusModels.LIGHT, LightWingsModel::getLayerDefinition);
        EntityModelLayerRegistry.registerModelLayer(IcarusModels.FLANDRE, FlandresWingsModel::getLayerDefinition);
        EntityModelLayerRegistry.registerModelLayer(IcarusModels.DISCORD, DiscordsWingsModel::getLayerDefinition);
        EntityModelLayerRegistry.registerModelLayer(IcarusModels.ZANZA, ZanzasWingsModel::getLayerDefinition);
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityType == class_1299.field_6097) {
                registrationHelper.register(new WingsLayer<>(entityRenderer, context.method_32170()));
            }
        });

        class_7923.field_41178.method_29722().forEach(entry -> {
            var item = entry.getValue();
            var key = entry.getKey();
            if (key.method_29177().method_12836().equals(Icarus.MODID) && item instanceof WingItem) {
                registerColorProvider(item);
            }
        });
        RegistryEntryAddedCallback.event(class_7923.field_41178).register((rawId, id, object) -> {
            if (id.method_12836().equals(Icarus.MODID) && object instanceof WingItem) {
                registerColorProvider(object);
            }
        });
    }

    private static void registerColorProvider(class_1792 item) {
        ColorProviderRegistry.ITEM.register((itemStack, tintIndex) -> tintIndex == 0 ? ColorHelper.dyeToDecimal(((WingItem) itemStack.method_7909()).getPrimaryColor(itemStack)) : ColorHelper.dyeToDecimal(((WingItem) itemStack.method_7909()).getSecondaryColor(itemStack)), item);
    }
}
