package dev.cammiescorner.icarus.fabric.entrypoints;

import dev.cammiescorner.icarus.Icarus;
import dev.cammiescorner.icarus.init.IcarusItems;
import dev.cammiescorner.icarus.init.IcarusStatusEffects;
import dev.cammiescorner.icarus.item.WingItem;
import dev.cammiescorner.icarus.util.IcarusHelper;
import dev.cammiescorner.icarus.util.Registrar;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_3414;
import net.minecraft.class_5151;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import java.util.function.Supplier;

public class Main implements ModInitializer {

    @Override
    public void onInitialize() {
        Icarus.init();

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> IcarusHelper.onServerPlayerJoin(handler.method_32311()));

        IcarusHelper.getEquippedWings = entity -> {
            var component = TrinketsApi.getTrinketComponent(entity);
            if (component.isPresent()) {
                var items = component.orElseThrow().getEquipped(stack -> stack.method_7909() instanceof WingItem);
                if (!items.isEmpty()) {
                    return items.get(0).method_15441();
                }
            }

            return class_1799.field_8037;
        };

        IcarusHelper.hasWings = entity -> {
            var component = TrinketsApi.getTrinketComponent(entity);
            return component.isPresent() && component.orElseThrow().isEquipped(stack -> stack.method_7909() instanceof WingItem);
        };

        IcarusHelper.equipFunc = (user, stack) -> {
            var optional = TrinketsApi.getTrinketComponent(user);
            if (optional.isPresent()) {
                TrinketComponent comp = optional.get();
                for (var group : comp.getInventory().values()) {
                    for (TrinketInventory inv : group.values()) {
                        for (int i = 0; i < inv.method_5439(); i++) {
                            if (inv.method_5438(i).method_7960()) {
                                SlotReference ref = new SlotReference(inv, i);
                                if (TrinketSlot.canInsert(stack, ref, user)) {
                                    class_1799 newStack = stack.method_7972();
                                    newStack.method_7939(1);
                                    inv.method_5447(i, newStack);
                                    class_3414 soundEvent = stack.method_7909() instanceof class_5151 eq ? eq.method_31570() : null;
                                    if (!stack.method_7960() && soundEvent != null) {
                                        user.method_32876(class_5712.field_28739);
                                        user.method_5783(soundEvent, 1.0F, 1.0F);
                                    }
                                    stack.method_7934(1);
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
            return false;
        };

        EntityElytraEvents.CUSTOM.register((entity, tickElytra) -> IcarusHelper.onFallFlyingTick(entity, IcarusHelper.getEquippedWings(entity), tickElytra));

        ServerLifecycleEvents.SERVER_STARTING.register(Icarus::onServerStart);

        IcarusItems.register(new Registrar<>() {
            @Override
            public <T extends class_1792> Supplier<T> register(String name, Supplier<? extends T> factory) {
                var value = class_2378.method_10230(class_7923.field_41178, Icarus.id(name), factory.get());
                return () -> value;
            }
        });

        IcarusStatusEffects.register(new Registrar<>() {
            @Override
            public <T extends class_1291> Supplier<T> register(String name, Supplier<? extends T> factory) {
                var value = class_2378.method_10230(class_7923.field_41174, Icarus.id(name), factory.get());
                return () -> value;
            }
        });

        var group = IcarusItems.makeTab(FabricItemGroup.builder());
        class_2378.method_10230(class_7923.field_44687, Icarus.id("icarus"), group);
    }
}
