package dev.cammiescorner.icarus.item;

import dev.cammiescorner.icarus.Icarus;
import dev.cammiescorner.icarus.IcarusConfig;
import dev.cammiescorner.icarus.init.IcarusItemTags;
import dev.cammiescorner.icarus.init.IcarusItems;
import dev.cammiescorner.icarus.util.IcarusHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class WingItem extends class_1792 {
    private final class_1767 primaryColor;
    private final class_1767 secondaryColor;
    private final WingType wingType;

    /**
     * The default constructor.
     */
    public WingItem(class_1767 primaryColor, class_1767 secondaryColor, WingType wingType) {
        super(new class_1792.class_1793().method_7895(IcarusConfig.wingsDurability).method_7894(wingType.rarity()));
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.wingType = wingType;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);

        if (IcarusHelper.equipFunc.test(player, stack)) {
            return class_1271.method_29237(stack, level.method_8608());
        }

        return super.method_7836(level, player, hand);
    }

    public boolean isUsable(class_1309 entity, class_1799 stack) {
        return IcarusConfig.wingsDurability <= 0 || stack.method_7919() < stack.method_7936() - 1;
    }

    public boolean onFlightTick(class_1309 entity, class_1799 wings, int ticks) {
        if (IcarusConfig.wingsDurability > 0 && wings.method_31573(IcarusItemTags.MELTS) && !(entity instanceof class_1657 player && player.method_7337())) {
            var cfg = IcarusHelper.getConfigValues(entity);
            if (ticks % 20 == 0 || (cfg.maxHeightEnabled() && entity.method_23318() > entity.method_37908().method_31605() + cfg.maxHeightAboveWorld() && ticks % 2 == 0)) {
                wings.method_7956(1, entity, e -> e.method_20235(class_1304.field_6174));
            }
        }

        return this.isUsable(entity, wings);
    }

    @Override
    public boolean method_7878(class_1799 current, class_1799 repair) {
        return repair.method_31573(IcarusItemTags.WING_REPAIR_ITEMS);
    }

    public class_1767 getPrimaryColor(class_1799 stack) {
        return this.primaryColor;
    }

    public class_1767 getSecondaryColor(class_1799 stack) {
        return this.secondaryColor;
    }

    public WingType getWingType() {
        return this.wingType;
    }

    public enum WingType {
        FEATHERED("feathered"), DRAGON("dragon"), MECHANICAL_FEATHERED("mechanical_feathered"), MECHANICAL_LEATHER("mechanical_leather"), LIGHT("light"), UNIQUE("__unique") {
            @Override
            public class_2960 getTextureLayer1(class_1799 wings) {
                if (wings.method_31574(IcarusItems.FLANDRES_WINGS.get())) {
                    return FLANDRES_WINGS_1;
                }
                if (wings.method_31574(IcarusItems.DISCORDS_WINGS.get())) {
                    return DISCORDS_WINGS_1;
                }
                if (wings.method_31574(IcarusItems.ZANZAS_WINGS.get())) {
                    return ZANZAS_WINGS_1;
                }
                return super.getTextureLayer1(wings);
            }

            @Override
            public class_2960 getTextureLayer2(class_1799 wings) {
                if (wings.method_31574(IcarusItems.FLANDRES_WINGS.get())) {
                    return FLANDRES_WINGS_2;
                }
                if (wings.method_31574(IcarusItems.DISCORDS_WINGS.get())) {
                    return DISCORDS_WINGS_2;
                }
                if (wings.method_31574(IcarusItems.ZANZAS_WINGS.get())) {
                    return ZANZAS_WINGS_2;
                }
                return super.getTextureLayer2(wings);
            }
        };

        private static final class_2960 FLANDRES_WINGS_1 = Icarus.id("textures/entity/flandres_wings.png");
        private static final class_2960 FLANDRES_WINGS_2 = Icarus.id("textures/entity/flandres_wings_2.png");
        private static final class_2960 DISCORDS_WINGS_1 = Icarus.id("textures/entity/discords_wings.png");
        private static final class_2960 DISCORDS_WINGS_2 = Icarus.id("textures/entity/discords_wings_2.png");
        private static final class_2960 ZANZAS_WINGS_1 = Icarus.id("textures/entity/zanzas_wings.png");
        private static final class_2960 ZANZAS_WINGS_2 = Icarus.id("textures/entity/zanzas_wings_2.png");

        private final class_2960 layer1;
        private final class_2960 layer2;

        WingType(String name) {
            this.layer1 = Icarus.id("textures/entity/" + name + "_wings.png");
            this.layer2 = Icarus.id("textures/entity/" + name + "_wings_2.png");
        }

        public class_1814 rarity() {
            return this == UNIQUE ? class_1814.field_8904 : class_1814.field_8903;
        }

        public class_2960 getTextureLayer1(class_1799 wings) {
            return this.layer1;
        }

        public class_2960 getTextureLayer2(class_1799 wings) {
            return this.layer2;
        }
    }
}
