package dev.cammiescorner.icarus.mixin.client;

import dev.cammiescorner.icarus.client.ClientPlayerFallbackValues;
import dev.cammiescorner.icarus.util.IcarusHelper;
import net.minecraft.class_310;
import net.minecraft.class_312;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(class_312.class)
public class MouseHandlerMixin {

    @Shadow
    @Final
    private class_310 minecraft;

    @ModifyArg(method = "turnPlayer", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;turn(DD)V"), index = 0)
    public double changeLookDirectionX(double x) {
        var player = minecraft.field_1724;

        // we inject inside a null check so this is just to make the IDE happy
        assert player != null;

        if ((player.method_36455() > 90 || player.method_36455() < -90) && ClientPlayerFallbackValues.canClientLoopDeLoop(player) && player.method_6128() && IcarusHelper.hasWings(player) && IcarusHelper.getConfigValues(player).canLoopDeLoop()) {
            return -x;
        }

        return x;
    }
}
