package dev.cammiescorner.icarus.util;

import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.api.SlowFallingEntity;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.init.IcarusDimensionTypeTags;
import dev.cammiescorner.icarus.init.IcarusItemTags;
import dev.cammiescorner.icarus.init.IcarusStatusEffects;
import dev.cammiescorner.icarus.item.WingItem;
import dev.cammiescorner.icarus.network.s2c.SyncConfigValuesPacket;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7924;

public class IcarusHelper {

    @ApiStatus.Internal
    public static Predicate<class_1309> hasWings = entity -> false;

    @ApiStatus.Internal
    public static Function<class_1309, class_1799> getEquippedWings = entity -> class_1799.field_8037;
    @ApiStatus.Internal
    public static BiPredicate<class_1309, class_1799> equipFunc = (entity, stack) -> false;

    @ApiStatus.Internal
    public static IcarusPlayerValues fallbackValues = new ServerPlayerFallbackValues();

    public static boolean onFallFlyingTick(class_1309 entity, @Nullable class_1799 wings, boolean tick) {
        IcarusPlayerValues cfg = IcarusHelper.getConfigValues(entity);
        var level = entity.method_37908();

        if(!level.method_8608()) {
            // level stem -> the actual level instance
            // dimension type -> all levels of a given type
            // some level stems (namely, AE2's spatial storage dimension) may not be registered properly
            // first check the dimension type, then check the level itself; if either one is in the no fly tag, cancel flying and send a message
            if(level.method_40134().method_40220(IcarusDimensionTypeTags.NO_FLYING_ALLOWED) || level.method_30349().method_30530(class_7924.field_41224).method_40264(class_7924.method_47518(level.method_27983())).map(stemHolder -> stemHolder.method_40220(cfg.noFlyingAllowedInLevels())).orElse(false)) {
                if (entity instanceof class_3222 player) {
                    stopFlying(player);
                    player.method_43502(class_2561.method_43471("message.icarus.status.no_fly.dimension").method_27692(class_124.field_1061), true);
                }
                return false;
            }
        }

        if (entity.method_6059(IcarusStatusEffects.FLIGHTLESS.get())) {
            if (entity instanceof class_1657 player) {
                stopFlying(player);
                class_2561 message = class_2561.method_43471("message.icarus.status.no_fly.status_effect").method_27692(class_124.field_1078);
                if (entity instanceof class_3222 serverPlayer) {
                    serverPlayer.method_43502(message, true);
                } else {
                    IcarusClient.sendActionbarMessage(player, message);
                }
            }
            return false;
        }


        if (wings != null && (!(wings.method_7909() instanceof WingItem wingItem) || !wingItem.isUsable(entity, wings))) {
            if (entity instanceof class_1657 player) {
                stopFlying(player);
            }
            return false;
        }

        if (tick) {
            if ((cfg.canSlowFall() && entity.method_5715()) || entity.method_5869()) {
                if (entity instanceof class_1657 player) {
                    stopFlying(player);
                }
                return false;
            }

            if ((wings == null || !wings.method_31573(IcarusItemTags.FREE_FLIGHT)) && entity instanceof class_1657 player && !player.method_7337()) {
                player.method_7344().method_7583(cfg.exhaustionAmount());
                if (player.method_7344().method_7586() < cfg.requiredFoodAmount()) {
                    stopFlying(player);
                    class_2561 message = class_2561.method_43471("message.icarus.status.no_fly.hunger").method_27692(class_124.field_1078);
                    if (entity instanceof class_3222 serverPlayer) {
                        serverPlayer.method_43502(message, true);
                    } else {
                        IcarusClient.sendActionbarMessage(player, message);
                    }
                    return false;
                }
            }

            if (wings != null && wings.method_7909() instanceof WingItem wingItem && !wingItem.onFlightTick(entity, wings, entity.method_6003() + 1)) {
                if (entity instanceof class_1657 player) {
                    stopFlying(player);
                }
                return false;
            }
        }

        return true;
    }

    public static boolean hasWings(class_1309 entity) {
        return hasWings.test(entity);
    }

    @Nullable
    public static class_1799 getEquippedWings(class_1309 entity) {
        return getEquippedWings.apply(entity);
    }

    public static IcarusPlayerValues getConfigValues(class_1309 entity) {
        return fallbackValues;
    }

    public static void onPlayerTick(class_1657 player) {
        if (((SlowFallingEntity) player).icarus$isSlowFalling()) {
            player.field_6017 = 0F;

            if (player.method_24828() || player.method_5799()) {
                ((SlowFallingEntity) player).icarus$setSlowFalling(false);
            } else {
                var move = player.method_18798();
                player.method_18800(move.method_10216(), -0.4, move.method_10215());
            }
        }
    }

    public static void stopFlying(class_1657 player) {
        ((SlowFallingEntity) player).icarus$setSlowFalling(true);

        if (player.method_36455() < -90 || player.method_36455() > 90) {
            float offset = (player.method_36455() < -90 ? player.method_36455() + 180 : player.method_36455() - 180) * 2;
            player.method_36457((player.method_36455() < -90 ? 180 + offset : -180 - offset) + player.method_36455());
            player.method_36456(180 + player.method_36454());
        }
    }

    public static void onServerPlayerJoin(class_3222 player) {
        SyncConfigValuesPacket.send(player);
    }
}
