/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client;

import com.google.common.base.MoreObjects;
import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.init.IcarusItemTags;
import dev.cammiescorner.icarus.util.IcarusHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public class IcarusClient {
    private static final List<Predicate<LivingEntity>> renderPredicates = new ArrayList<Predicate<LivingEntity>>();

    public static void onPlayerTick(Player player) {
        if (player.m_21255_() && IcarusHelper.hasWings((LivingEntity)player) && player.f_20902_ > 0.0f) {
            ItemStack wings;
            IcarusPlayerValues cfg = IcarusHelper.getConfigValues((LivingEntity)player);
            Vec3 rotation = player.m_20154_();
            Vec3 velocity = player.m_20184_();
            float modifier = 1.0f;
            if (cfg.armorSlows() && (wings = IcarusHelper.getEquippedWings.apply((LivingEntity)player)) != null && !wings.m_41619_() && !wings.m_204117_(IcarusItemTags.BYPASSES_ARMOR_SLOWDOWN)) {
                modifier = Math.max(1.0f, (float)player.m_21230_() / 30.0f * cfg.maxSlowedMultiplier());
            }
            float speed = cfg.wingsSpeed() * (player.m_146909_() < -75.0f && player.m_146909_() > -105.0f ? 2.75f : 1.0f) / modifier;
            player.m_20256_(velocity.m_82520_(rotation.f_82479_ * (double)speed + (rotation.f_82479_ * 1.5 - velocity.f_82479_) * (double)speed, rotation.f_82480_ * (double)speed + (rotation.f_82480_ * 1.5 - velocity.f_82480_) * (double)speed, rotation.f_82481_ * (double)speed + (rotation.f_82481_ * 1.5 - velocity.f_82481_) * (double)speed));
        }
    }

    @ApiStatus.Internal
    public static ItemStack getWingsForRendering(LivingEntity entity) {
        return (ItemStack)MoreObjects.firstNonNull((Object)IcarusHelper.getEquippedWings.apply(entity), (Object)ItemStack.f_41583_);
    }

    @ApiStatus.Internal
    public static void addRenderPredicate(Predicate<LivingEntity> predicate) {
        renderPredicates.add(predicate);
    }

    public static boolean shouldRenderWings(LivingEntity entity) {
        if (!renderPredicates.isEmpty()) {
            for (Predicate<LivingEntity> predicate : renderPredicates) {
                if (predicate.test(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public static void sendActionbarMessage(Player player, Component message) {
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            localPlayer.m_5661_(message, true);
        }
    }
}

