package dev.cammiescorner.icarus.client.renderers;

import dev.cammiescorner.icarus.api.client.IcarusAPIClient;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.client.IcarusModels;
import dev.cammiescorner.icarus.client.models.*;
import dev.cammiescorner.icarus.init.IcarusItems;
import dev.cammiescorner.icarus.item.WingItem;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

//TODO clean up
public class WingsLayer<T extends class_1309, M extends class_583<T>> extends class_3887<T, M> {
    private final FeatheredWingsModel<T> featheredWings;
    private final LeatherWingsModel<T> leatherWings;
    private final LightWingsModel<T> lightWings;
    private final FlandresWingsModel<T> flandresWings;
    private final DiscordsWingsModel<T> discordsWings;
    private final ZanzasWingsModel<T> zanzasWings;

    public WingsLayer(class_3883<T, M> context, class_5599 loader) {
        super(context);
        this.featheredWings = new FeatheredWingsModel<>(loader.method_32072(IcarusModels.FEATHERED));
        this.leatherWings = new LeatherWingsModel<>(loader.method_32072(IcarusModels.LEATHER));
        this.lightWings = new LightWingsModel<>(loader.method_32072(IcarusModels.LIGHT));
        this.flandresWings = new FlandresWingsModel<>(loader.method_32072(IcarusModels.FLANDRE));
        this.discordsWings = new DiscordsWingsModel<>(loader.method_32072(IcarusModels.DISCORD));
        this.zanzasWings = new ZanzasWingsModel<>(loader.method_32072(IcarusModels.ZANZA));
    }

    @Override
    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        var stack = IcarusAPIClient.getWingsForRendering(entity);

        if (stack.method_7909() instanceof WingItem wingItem && IcarusClient.shouldRenderWings(entity)) {
            float[] primaryColour = wingItem.getPrimaryColor(stack).method_7787();
            float[] secondaryColour = wingItem.getSecondaryColor(stack).method_7787();
            float r1 = primaryColour[0];
            float g1 = primaryColour[1];
            float b1 = primaryColour[2];
            float r2 = secondaryColour[0];
            float g2 = secondaryColour[1];
            float b2 = secondaryColour[2];

            var wingModel = switch (wingItem.getWingType()) {
                case FEATHERED, MECHANICAL_FEATHERED -> featheredWings;
                case DRAGON, MECHANICAL_LEATHER -> leatherWings;
                case LIGHT -> lightWings;
                case UNIQUE -> {
                    if (stack.method_31574(IcarusItems.FLANDRES_WINGS.get())) {
                        yield flandresWings;
                    }
                    if (stack.method_31574(IcarusItems.DISCORDS_WINGS.get())) {
                        yield discordsWings;
                    }
                    if (stack.method_31574(IcarusItems.ZANZAS_WINGS.get())) {
                        yield zanzasWings;
                    }
                    yield null;
                }
                default -> null;
            };
            if (wingModel == null) {
                return;
            }

            class_2960 layer1 = wingItem.getWingType().getTextureLayer1(stack);
            class_2960 layer2 = wingItem.getWingType().getTextureLayer2(stack);

            matrices.method_22903();
            matrices.method_22904(0.0D, 0.0D, 0.125D);
            this.method_17165().method_17081(wingModel);
            wingModel.setupAnim(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            this.renderWings(wingModel, matrices, vertexConsumers, stack, class_1921.method_23580(layer2), light, r2, g2, b2);
            this.renderWings(wingModel, matrices, vertexConsumers, stack, class_1921.method_23580(layer1), light, r1, g1, b1);
            matrices.method_22909();
        }
    }

    public void renderWings(WingEntityModel<T> model, class_4587 matrices, class_4597 vertexConsumers, @Nullable class_1799 stack, class_1921 renderLayer, int light, float r, float g, float b) {
        class_4588 vertexConsumer = class_918.method_27952(vertexConsumers, renderLayer, false, stack != null && stack.method_7958());
        model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, r, g, b, 1F);
    }
}
