package dev.cammiescorner.icarus.api;

import dev.cammiescorner.icarus.IcarusConfig;
import dev.cammiescorner.icarus.init.IcarusDimensionTypeTags;
import dev.cammiescorner.icarus.init.IcarusLevelTags;
import net.minecraft.class_2874;
import net.minecraft.class_5363;
import net.minecraft.class_6862;

public interface IcarusPlayerValues {

    float wingsSpeed();

    float maxSlowedMultiplier();

    boolean armorSlows();

    boolean canLoopDeLoop();

    boolean canSlowFall();

    float exhaustionAmount();

    int maxHeightAboveWorld();

    boolean maxHeightEnabled();

    default class_6862<class_5363> noFlyingAllowedInLevels() {
        return IcarusLevelTags.NO_FLYING_ALLOWED;
    }

    default class_6862<class_2874> noFlyingAllowedInDimensions() {
        return IcarusDimensionTypeTags.NO_FLYING_ALLOWED;
    }

    default float requiredFoodAmount() {
        return IcarusConfig.requiredFoodAmount;
    }
}
