package dev.cammiescorner.icarus.client.renderers;

import dev.cammiescorner.icarus.api.client.IcarusAPIClient;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.client.IcarusModels;
import dev.cammiescorner.icarus.client.models.*;
import dev.cammiescorner.icarus.init.IcarusItems;
import dev.cammiescorner.icarus.item.WingItem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import net.minecraft.class_7923;
import net.minecraft.class_918;

//TODO clean up
public class WingsLayer<T extends class_1309, M extends class_583<T>> extends class_3887<T, M> {
    private final FeatheredWingsModel<T> featheredWings;
    private final LeatherWingsModel<T> leatherWings;
    private final LightWingsModel<T> lightWings;
    private final FlandresWingsModel<T> flandresWings;
    private final DiscordsWingsModel<T> discordsWings;
    private final ZanzasWingsModel<T> zanzasWings;

    private static final Map<class_1792, class_2960[]> TEXTURE_LOOKUP = new Reference2ObjectOpenHashMap<>();

    public WingsLayer(class_3883<T, M> context, class_5599 loader) {
        super(context);
        this.featheredWings = new FeatheredWingsModel<>(loader.method_32072(IcarusModels.FEATHERED));
        this.leatherWings = new LeatherWingsModel<>(loader.method_32072(IcarusModels.LEATHER));
        this.lightWings = new LightWingsModel<>(loader.method_32072(IcarusModels.LIGHT));
        this.flandresWings = new FlandresWingsModel<>(loader.method_32072(IcarusModels.FLANDRE));
        this.discordsWings = new DiscordsWingsModel<>(loader.method_32072(IcarusModels.DISCORD));
        this.zanzasWings = new ZanzasWingsModel<>(loader.method_32072(IcarusModels.ZANZA));
    }

    @Override
    public void render(class_4587 pose, class_4597 bufferSource, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        var stack = IcarusAPIClient.getWingsForRendering(entity);

        if (stack.method_7909() instanceof WingItem wingItem && IcarusClient.shouldRenderWings(entity)) {
            var wingModel = switch (wingItem.getWingType()) {
                case FEATHERED, MECHANICAL_FEATHERED -> featheredWings;
                case DRAGON, MECHANICAL_LEATHER -> leatherWings;
                case LIGHT -> lightWings;
                case UNIQUE -> {
                    if (stack.method_31574(IcarusItems.FLANDRES_WINGS.get())) {
                        yield flandresWings;
                    }
                    if (stack.method_31574(IcarusItems.DISCORDS_WINGS.get())) {
                        yield discordsWings;
                    }
                    if (stack.method_31574(IcarusItems.ZANZAS_WINGS.get())) {
                        yield zanzasWings;
                    }
                    yield null;
                }
                default -> null;
            };
            if (wingModel == null) {
                return;
            }

            var textures = TEXTURE_LOOKUP.computeIfAbsent(wingItem, item -> {
                var baseId = class_7923.field_41178.method_10221(item).method_45138("textures/entity/icarus/wings/");
                return new class_2960[] {
                    baseId.method_48331(".png"),
                    baseId.method_48331("_2.png")
                };
            });

            pose.method_22903();
            pose.method_22904(0.0D, 0.0D, 0.125D);
            this.method_17165().method_17081(wingModel);
            wingModel.setupAnim(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            this.renderWings(wingModel, pose, bufferSource, stack, class_1921.method_23580(textures[0]), light, 0xFFFFFFFF);
            this.renderWings(wingModel, pose, bufferSource, stack, class_1921.method_23580(textures[1]), light, 0xFFFFFFFF);
            pose.method_22909();
        }
    }

    public void renderWings(WingEntityModel<T> model, class_4587 matrices, class_4597 vertexConsumers, @Nullable class_1799 stack, class_1921 renderLayer, int light, int color) {
        class_4588 vertexConsumer = class_918.method_27952(vertexConsumers, renderLayer, stack != null && stack.method_7958());
        model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, color);
    }
}
