package dev.cammiescorner.icarus.fabric.entrypoints;

import dev.cammiescorner.icarus.item.WingItem;
import dev.cammiescorner.icarus.util.IcarusHelper;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1799;
import net.minecraft.class_5151;
import net.minecraft.class_5712;

public class Main implements ModInitializer {

    @Override
    public void onInitialize() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> IcarusHelper.onServerPlayerJoin(handler.method_32311()));

        IcarusHelper.getEquippedWings = entity -> {
            var component = TrinketsApi.getTrinketComponent(entity);
            if (component.isPresent()) {
                var items = component.orElseThrow().getEquipped(stack -> stack.method_7909() instanceof WingItem);
                if (!items.isEmpty()) {
                    return items.get(0).method_15441();
                }
            }

            return class_1799.field_8037;
        };

        IcarusHelper.hasWings = entity -> {
            var component = TrinketsApi.getTrinketComponent(entity);
            return component.isPresent() && component.orElseThrow().isEquipped(stack -> stack.method_7909() instanceof WingItem);
        };

        IcarusHelper.equipFunc = (user, stack) -> {
            var optional = TrinketsApi.getTrinketComponent(user);
            if (optional.isPresent()) {
                TrinketComponent comp = optional.get();
                for (var group : comp.getInventory().values()) {
                    for (TrinketInventory inv : group.values()) {
                        for (int i = 0; i < inv.method_5439(); i++) {
                            if (inv.method_5438(i).method_7960()) {
                                SlotReference ref = new SlotReference(inv, i);
                                if (TrinketSlot.canInsert(stack, ref, user)) {
                                    class_1799 newStack = stack.method_7972();
                                    newStack.method_7939(1);
                                    inv.method_5447(i, newStack);
                                    var soundEvent = stack.method_7909() instanceof class_5151 eq ? eq.method_31570() : null;
                                    if (!stack.method_7960()) {
                                        user.method_32876(class_5712.field_28739);
                                        if(soundEvent != null && !user.method_5701()) {
                                            user.method_37908().method_8465(null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent, user.method_5634(), 1.0F, 1.0F, user.method_59922().method_43055());
                                        }
                                    }
                                    stack.method_7934(1);
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
            return false;
        };

        EntityElytraEvents.CUSTOM.register((entity, tickElytra) -> IcarusHelper.onFallFlyingTick(entity, IcarusHelper.getEquippedWings(entity), tickElytra));
    }
}
