package dev.cammiescorner.icarus.integration.figura;

import com.mojang.datafixers.util.Pair;
import dev.cammiescorner.icarus.Icarus;
import dev.cammiescorner.icarus.client.models.WingEntityModel;
import org.figuramc.figura.entries.FiguraVanillaPart;
import org.figuramc.figura.entries.annotations.FiguraVanillaPartPlugin;
import org.figuramc.figura.model.ParentType;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_583;
import net.minecraft.class_630;

@SuppressWarnings("unused")
@FiguraVanillaPartPlugin
public class IcarusFiguraModelPartsPlugin implements FiguraVanillaPart {

    @Override
    public String getID() {
        return Icarus.MODID;
    }

    @Override
    public Collection<Pair<String, Function<class_583<?>, class_630>>> getParts() {
        return List.of();
    }

    @Override
    public Collection<Pair<String, Pair<Function<class_583<?>, class_630>, ParentType>>> getPartsWithParent() {
        return List.of(
                new Pair<>("right_wing", new Pair<>(model -> model instanceof WingEntityModel<?> wingModel ? wingModel.rightWing : null, ParentType.RightElytraPivot)),
                new Pair<>("left_wing", new Pair<>(model -> model instanceof WingEntityModel<?> wingModel ? wingModel.leftWing : null, ParentType.LeftElytraPivot))
        );
    }
}
