package dev.cammiescorner.icarus.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.cammiescorner.icarus.IcarusConfig;
import dev.cammiescorner.icarus.util.IcarusHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@SuppressWarnings("UnreachableCode")
@Mixin(class_1297.class)
public abstract class EntityMixin {

    @Shadow public abstract float getXRot();

    @Shadow public float xRotO;

    @SuppressWarnings("ConstantValue")
    @ModifyReturnValue(method = "getPickRadius", at = @At("RETURN"))
    private float icarus$targetRadius(float original) {
        if(((Object) this) instanceof class_1657 player && player.method_6128())
            return Math.max(IcarusConfig.flyingTargetRadius, original * (1 + IcarusConfig.flyingTargetRadius));

        return original;
    }

    @ModifyExpressionValue(method = "turn", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/Mth;clamp(FFF)F", ordinal = 0))
    private float icarus$updateLookDirection(float original) {
        if(((Object) this) instanceof class_1309 living) {
            return living.method_6128() && IcarusHelper.hasWings(living) ? class_3532.method_15393(this.getXRot()) : original;
        }
        return original;
    }

    @ModifyExpressionValue(method = "turn", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/Mth;clamp(FFF)F", ordinal = 1))
    private float icarus$updateLookDirection0(float original) {
        if (((Object) this) instanceof class_1309 living) {
            return living.method_6128() && IcarusHelper.hasWings(living) ? class_3532.method_15393(this.xRotO) : original;
        }
        return original;
    }
}
