/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.network.s2c;

import commonnetwork.api.Dispatcher;
import commonnetwork.networking.data.PacketContext;
import dev.cammiescorner.icarus.Icarus;
import dev.cammiescorner.icarus.client.ClientPlayerFallbackValues;
import dev.cammiescorner.icarus.util.IcarusHelper;
import dev.cammiescorner.icarus.util.ServerPlayerFallbackValues;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record SyncConfigValuesPacket(float wingsSpeed, float maxSlowedMultiplier, boolean armorSlows, boolean canLoopDeLoop, float requiredFoodAmount) {
    public static final ResourceLocation ID = Icarus.id("sync_config_values");
    public static final CustomPacketPayload.Type<CustomPacketPayload> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, SyncConfigValuesPacket> STREAM_CODEC = StreamCodec.ofMember(SyncConfigValuesPacket::encode, SyncConfigValuesPacket::decode);

    private void encode(FriendlyByteBuf buf) {
        buf.writeFloat(this.wingsSpeed());
        buf.writeFloat(this.maxSlowedMultiplier());
        buf.writeBoolean(this.armorSlows());
        buf.writeBoolean(this.canLoopDeLoop());
        buf.writeFloat(this.requiredFoodAmount());
    }

    public static void send(ServerPlayer player) {
        ServerPlayerFallbackValues cfg = new ServerPlayerFallbackValues();
        SyncConfigValuesPacket packet = new SyncConfigValuesPacket(cfg.wingsSpeed(), cfg.maxSlowedMultiplier(), cfg.armorSlows(), cfg.canLoopDeLoop(), cfg.requiredFoodAmount());
        Dispatcher.sendToClient((Object)packet, (ServerPlayer)player);
    }

    private static SyncConfigValuesPacket decode(FriendlyByteBuf buf) {
        float wingsSpeed = buf.readFloat();
        float maxSlowedMultiplier = buf.readFloat();
        boolean armorSlows = buf.readBoolean();
        boolean canLoopDeLoop = buf.readBoolean();
        float requiredFoodAmount = buf.readFloat();
        return new SyncConfigValuesPacket(wingsSpeed, maxSlowedMultiplier, armorSlows, canLoopDeLoop, requiredFoodAmount);
    }

    public static void handle(PacketContext<SyncConfigValuesPacket> ctx) {
        ClientHandler.handle(ctx);
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        private static void handle(PacketContext<SyncConfigValuesPacket> ctx) {
            Minecraft.getInstance().execute(() -> {
                IcarusHelper.fallbackValues = new ClientPlayerFallbackValues(((SyncConfigValuesPacket)ctx.message()).wingsSpeed(), ((SyncConfigValuesPacket)ctx.message()).maxSlowedMultiplier(), ((SyncConfigValuesPacket)ctx.message()).armorSlows(), ((SyncConfigValuesPacket)ctx.message()).canLoopDeLoop(), ((SyncConfigValuesPacket)ctx.message()).requiredFoodAmount());
            });
        }
    }
}

