/*
 * Decompiled with CFR 0.152.
 */
package top.syutopia.wEBAPI;

import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class WebServer
extends NanoHTTPD {
    private final File dataFile;

    public WebServer(int port, File dataFile) throws IOException {
        super(port);
        this.dataFile = dataFile;
        this.start(5000, false);
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        try {
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)this.dataFile);
            Map map = yaml.getValues(true);
            String json = this.toJson(map);
            return WebServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", json);
        }
        catch (Exception e) {
            return WebServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "Error: " + e.getMessage());
        }
    }

    private String toJson(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"").append(entry.getKey()).append("\":");
            Object value = entry.getValue();
            if (value instanceof String) {
                sb.append("\"").append(value).append("\"");
            } else {
                sb.append(value);
            }
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }
}

