/*
 * Decompiled with CFR 0.152.
 */
package top.syutopia.wEBAPI;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.scheduler.BukkitRunnable;
import top.syutopia.wEBAPI.WEBAPI;

public class DataUpdater
extends BukkitRunnable {
    private final WEBAPI plugin;
    private final File dataFile;
    private final FileConfiguration config;

    public DataUpdater(WEBAPI plugin, File dataFile, FileConfiguration config) {
        this.plugin = plugin;
        this.dataFile = dataFile;
        this.config = config;
    }

    public void run() {
        ArrayList players = new ArrayList();
        boolean showZero = this.config.getBoolean("display.show-empty-as-zero", true);
        Map features = this.config.getConfigurationSection("features").getValues(false);
        for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
            LinkedHashMap<String, String> pdata = new LinkedHashMap<String, String>();
            pdata.put("name", op.getName());
            for (String key : features.keySet()) {
                if (!this.config.getBoolean("features." + key + ".enabled", false)) continue;
                String papi = this.config.getString("features." + key + ".papi");
                String value = "";
                if (papi != null && op.getName() != null) {
                    value = PlaceholderAPI.setPlaceholders((OfflinePlayer)op, (String)papi);
                }
                String defaultValue = this.config.getString("features." + key + ".default", "");
                if (showZero && (value == null || value.isEmpty() || value.equalsIgnoreCase("null"))) {
                    value = defaultValue;
                }
                pdata.put(key, value);
            }
            players.add(pdata);
        }
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.set("timestamp", (Object)(System.currentTimeMillis() / 1000L));
        yaml.set("players", players);
        try {
            yaml.save(this.dataFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

