/*
 * Decompiled with CFR 0.152.
 */
package top.syutopia.wEBAPI;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import top.syutopia.wEBAPI.DataUpdater;
import top.syutopia.wEBAPI.WebServer;

public final class WEBAPI
extends JavaPlugin {
    private WebServer webServer;
    private DataUpdater dataUpdater;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        int port = config.getInt("web.port", 12232);
        File dataFile = new File(this.getDataFolder(), "data.yml");
        try {
            this.webServer = new WebServer(port, dataFile);
            this.getLogger().info("Web server started on port " + port);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to start web server: " + e.getMessage());
        }
        int interval = config.getInt("data.update-interval", 300);
        this.dataUpdater = new DataUpdater(this, dataFile, config);
        this.dataUpdater.runTaskTimerAsynchronously((Plugin)this, 0L, (long)interval * 20L);
        this.getLogger().info("Data updater scheduled every " + interval + " seconds.");
    }

    public void onDisable() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }
}

