/*
 * Decompiled with CFR 0.152.
 */
package top.syutopia.wEBAPI;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import top.syutopia.wEBAPI.DataUpdater;
import top.syutopia.wEBAPI.WebServer;

public final class WEBAPI
extends JavaPlugin {
    private WebServer webServer;
    private DataUpdater dataUpdater;
    private DataUpdater lastLoginUpdater;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        int port = config.getInt("web.port", 12232);
        File dataFile = new File(this.getDataFolder(), "data.yml");
        try {
            this.webServer = new WebServer(port, dataFile);
            this.getLogger().info("Web server started on port " + port);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to start web server: " + e.getMessage());
        }
        int interval = config.getInt("data.update-interval", 300);
        this.dataUpdater = new DataUpdater(this, dataFile, config);
        this.dataUpdater.runTaskTimerAsynchronously((Plugin)this, 0L, (long)interval * 20L);
        this.getLogger().info("Data updater scheduled every " + interval + " seconds.");
        int lastLoginDays = config.getInt("data.user-last-login-update-days", 1);
        int lastLoginInterval = lastLoginDays * 86400;
        this.lastLoginUpdater = new DataUpdater(this, dataFile, config){

            @Override
            public void run() {
                ArrayList players = new ArrayList();
                HashMap<String, OfflinePlayer> latestPlayers = new HashMap<String, OfflinePlayer>();
                for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
                    String name = op.getName();
                    if (name == null || latestPlayers.containsKey(name) && op.getLastPlayed() <= ((OfflinePlayer)latestPlayers.get(name)).getLastPlayed()) continue;
                    latestPlayers.put(name, op);
                }
                for (OfflinePlayer op : latestPlayers.values()) {
                    LinkedHashMap<String, Object> pdata = new LinkedHashMap<String, Object>();
                    pdata.put("name", op.getName());
                    pdata.put("lastPlayed", op.getLastPlayed());
                    players.add(pdata);
                }
                YamlConfiguration yaml = new YamlConfiguration();
                yaml.set("timestamp", (Object)(System.currentTimeMillis() / 1000L));
                yaml.set("players", players);
                try {
                    yaml.save(new File(WEBAPI.this.getDataFolder(), "user-last-login.yml"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.lastLoginUpdater.runTaskTimerAsynchronously((Plugin)this, 0L, (long)lastLoginInterval * 20L);
        this.getLogger().info("User last login updater scheduled every " + lastLoginDays + " days (" + lastLoginInterval + " seconds).");
    }

    public void onDisable() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.lastLoginUpdater != null) {
            this.lastLoginUpdater.cancel();
        }
    }
}

