/*
 * Decompiled with CFR 0.152.
 */
package top.syutopia.wEBAPI;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.scheduler.BukkitRunnable;
import top.syutopia.wEBAPI.WEBAPI;

public class DataUpdater
extends BukkitRunnable {
    private final WEBAPI plugin;
    private final File dataFile;
    private final FileConfiguration config;
    private long lastFullSnapshot = 0L;

    public DataUpdater(WEBAPI plugin, File dataFile, FileConfiguration config) {
        this.plugin = plugin;
        this.dataFile = dataFile;
        this.config = config;
    }

    public void run() {
        long days;
        long interval;
        long now;
        ArrayList players = new ArrayList();
        boolean showZero = this.config.getBoolean("display.show-empty-as-zero", true);
        Map features = this.config.getConfigurationSection("features").getValues(false);
        HashMap<String, OfflinePlayer> latestPlayers = new HashMap<String, OfflinePlayer>();
        for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
            String name = op.getName();
            if (name == null || latestPlayers.containsKey(name) && op.getLastPlayed() <= ((OfflinePlayer)latestPlayers.get(name)).getLastPlayed()) continue;
            latestPlayers.put(name, op);
        }
        for (OfflinePlayer op : latestPlayers.values()) {
            LinkedHashMap<String, String> pdata = new LinkedHashMap<String, String>();
            pdata.put("name", op.getName());
            for (String key : features.keySet()) {
                if (!this.config.getBoolean("features." + key + ".enabled", false)) continue;
                String papi = this.config.getString("features." + key + ".papi");
                String value = "";
                if (papi != null && op.getName() != null) {
                    value = PlaceholderAPI.setPlaceholders((OfflinePlayer)op, (String)papi);
                }
                String defaultValue = this.config.getString("features." + key + ".default", "");
                if (showZero && (value == null || value.isEmpty() || value.equalsIgnoreCase("null"))) {
                    value = defaultValue;
                }
                pdata.put(key, value);
            }
            players.add(pdata);
        }
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.set("timestamp", (Object)(System.currentTimeMillis() / 1000L));
        yaml.set("players", players);
        try {
            yaml.save(this.dataFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.config.getBoolean("data.full-snapshot.enabled", false) && (now = System.currentTimeMillis() / 1000L) - this.lastFullSnapshot >= (interval = (days = this.config.getLong("data.full-snapshot.days", 7L)) * 86400L)) {
            this.lastFullSnapshot = now;
            File fullFile = new File(this.plugin.getDataFolder(), this.config.getString("data.full-snapshot.file", "data-full.yml"));
            ArrayList allPlayers = new ArrayList();
            for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
                String name = op.getName();
                if (name == null) continue;
                LinkedHashMap<String, String> pdata = new LinkedHashMap<String, String>();
                pdata.put("name", name);
                for (String key : features.keySet()) {
                    if (!this.config.getBoolean("features." + key + ".enabled", false)) continue;
                    String papi = this.config.getString("features." + key + ".papi");
                    String value = "";
                    if (papi != null && name != null) {
                        value = PlaceholderAPI.setPlaceholders((OfflinePlayer)op, (String)papi);
                    }
                    String defaultValue = this.config.getString("features." + key + ".default", "");
                    if (showZero && (value == null || value.isEmpty() || value.equalsIgnoreCase("null"))) {
                        value = defaultValue;
                    }
                    pdata.put(key, value);
                }
                allPlayers.add(pdata);
            }
            YamlConfiguration fullYaml = new YamlConfiguration();
            fullYaml.set("timestamp", (Object)now);
            fullYaml.set("players", allPlayers);
            try {
                fullYaml.save(fullFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

