/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Stick_Sword;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.little100.super_Stick_Sword.Super_Stick_Sword;

public class LanguageManager {
    private final Super_Stick_Sword plugin;
    private final Map<String, YamlConfiguration> languages = new HashMap<String, YamlConfiguration>();
    private final Map<UUID, String> playerLanguages = new HashMap<UUID, String>();
    private String defaultLanguage = "zh_cn";

    public LanguageManager(Super_Stick_Sword plugin) {
        this.plugin = plugin;
        this.loadLanguages();
    }

    private void loadLanguages() {
        File[] langFiles;
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
            this.plugin.saveResource("lang/zh_cn.yml", false);
            this.plugin.saveResource("lang/en_us.yml", false);
            this.plugin.saveResource("lang/lzh.yml", false);
        }
        if ((langFiles = langFolder.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : langFiles) {
                String langCode = file.getName().replace(".yml", "");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                this.languages.put(langCode, config);
                this.plugin.getLogger().info("Loaded language: " + langCode);
            }
        }
        if (this.languages.isEmpty()) {
            this.loadLanguageFromResource("zh_cn");
            this.loadLanguageFromResource("en_us");
            this.loadLanguageFromResource("lzh");
        }
    }

    private void loadLanguageFromResource(String langCode) {
        InputStream is = this.plugin.getResource("lang/" + langCode + ".yml");
        if (is != null) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
            this.languages.put(langCode, config);
            this.plugin.getLogger().info("Loaded language from resource: " + langCode);
        } else {
            this.plugin.getLogger().warning("Could not find language resource: " + langCode);
        }
    }

    public String getMessage(String key) {
        return this.getMessage(this.defaultLanguage, key);
    }

    public String getMessage(String lang, String key) {
        YamlConfiguration langConfig = this.languages.get(lang);
        if (langConfig != null && langConfig.contains(key)) {
            return langConfig.getString(key);
        }
        if (!lang.equals(this.defaultLanguage) && (langConfig = this.languages.get(this.defaultLanguage)) != null && langConfig.contains(key)) {
            return langConfig.getString(key);
        }
        return key;
    }

    public String getMessage(Player player, String key) {
        String lang = this.playerLanguages.getOrDefault(player.getUniqueId(), this.defaultLanguage);
        return this.getMessage(lang, key);
    }

    public void setPlayerLanguage(Player player, String lang) {
        if (this.languages.containsKey(lang)) {
            this.playerLanguages.put(player.getUniqueId(), lang);
        } else {
            this.plugin.getLogger().warning("Tried to set unknown language: " + lang + " for player " + player.getName());
        }
    }

    public String[] getAvailableLanguages() {
        return this.languages.keySet().toArray(new String[0]);
    }

    public void setDefaultLanguage(String lang) {
        if (this.languages.containsKey(lang)) {
            this.defaultLanguage = lang;
        } else {
            this.plugin.getLogger().warning("Tried to set unknown default language: " + lang);
        }
    }

    public String getItemName(String itemKey) {
        return this.getMessage("items." + itemKey);
    }

    public String getItemName(Player player, String itemKey) {
        return this.getMessage(player, "items." + itemKey);
    }
}

