/*
 * Decompiled with CFR 0.152.
 */
package org.little100.super_Stick_Sword.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.little100.super_Stick_Sword.ItemManager;
import org.little100.super_Stick_Sword.LanguageManager;
import org.little100.super_Stick_Sword.Super_Stick_Sword;

public class LanguageCommand
implements CommandExecutor,
TabCompleter {
    private final Super_Stick_Sword plugin;
    private final LanguageManager languageManager;

    public LanguageCommand(Super_Stick_Sword plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/sss language [" + String.join((CharSequence)"|", this.languageManager.getAvailableLanguages()) + "]");
            return true;
        }
        String langCode = args[0].toLowerCase();
        if (Arrays.asList(this.languageManager.getAvailableLanguages()).contains(langCode)) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.languageManager.setPlayerLanguage(player, langCode);
                ItemManager.updatePlayerItems(player);
                Object message = this.languageManager.getMessage(langCode, "commands.language_changed");
                if (message == null || ((String)message).isEmpty()) {
                    message = "Language changed to " + langCode;
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + (String)message);
            } else {
                this.languageManager.setDefaultLanguage(langCode);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Server default language changed to " + langCode);
            }
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Available languages: " + String.join((CharSequence)", ", this.languageManager.getAvailableLanguages()));
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            String partialArg = args[0].toLowerCase();
            return Arrays.stream(this.languageManager.getAvailableLanguages()).filter(lang -> lang.startsWith(partialArg)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

