/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.enchantments.enchantment;

import com.devnemo.nemos.enchantments.Constants;
import com.devnemo.nemos.enchantments.entity.attribute.NemosAttributes;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.DamageImmunity;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.ReplaceDisk;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;

public class NemosEnchantments {
    public static final ResourceKey<Enchantment> SOUL_BINDING = NemosEnchantments.createResourceKey("soul_binding");
    public static final ResourceKey<Enchantment> CLIMBER = NemosEnchantments.createResourceKey("climber");
    public static final ResourceKey<Enchantment> SPRINTER = NemosEnchantments.createResourceKey("sprinter");
    public static final ResourceKey<Enchantment> FARMERS_KNOWLEDGE = NemosEnchantments.createResourceKey("farmers_knowledge");
    public static final ResourceKey<Enchantment> REAPER = NemosEnchantments.createResourceKey("reaper");
    public static final ResourceKey<Enchantment> REPLANTING = NemosEnchantments.createResourceKey("replanting");
    public static final ResourceKey<Enchantment> MAGMA_WALKER = NemosEnchantments.createResourceKey("magma_walker");
    public static final ResourceKey<Enchantment> SNOW_WALKER = NemosEnchantments.createResourceKey("snow_walker");
    public static final ResourceKey<Enchantment> COLLECTOR = NemosEnchantments.createResourceKey("collector");
    public static final ResourceKey<Enchantment> WISDOM = NemosEnchantments.createResourceKey("wisdom");

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        Constants.LOG.info("Registering enchantments");
        HolderGetter enchantmentLookup = context.lookup(Registries.ENCHANTMENT);
        HolderGetter itemLookup = context.lookup(Registries.ITEM);
        NemosEnchantments.register(context, SOUL_BINDING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.DURABILITY_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)25), (int)40, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})).exclusiveWith((HolderSet)enchantmentLookup.getOrThrow(EnchantmentTags.CURSE)).withEffect(EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP));
        NemosEnchantments.register(context, CLIMBER, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.FOOT_ARMOR_ENCHANTABLE), (int)4, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.FEET})).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"nemos_enchantments", (String)"enchantment.climber"), NemosAttributes.CLIMBING_EFFICIENCY.get(), (LevelBasedValue)LevelBasedValue.perLevel((float)0.05f), AttributeModifier.Operation.ADD_VALUE)));
        NemosEnchantments.register(context, SPRINTER, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.FOOT_ARMOR_ENCHANTABLE), (int)4, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.FEET})).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"nemos_enchantments", (String)"enchantment.sprinter"), Attributes.MOVEMENT_SPEED, (LevelBasedValue)LevelBasedValue.perLevel((float)0.02f), AttributeModifier.Operation.ADD_VALUE)));
        NemosEnchantments.register(context, FARMERS_KNOWLEDGE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.HOES), (int)3, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)15), (Enchantment.Cost)Enchantment.constantCost((int)65), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        NemosEnchantments.register(context, REPLANTING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.HOES), (int)3, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)15), (Enchantment.Cost)Enchantment.constantCost((int)65), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        NemosEnchantments.register(context, REAPER, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.HOES), (int)3, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)65, (int)9), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        NemosEnchantments.register(context, MAGMA_WALKER, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.FOOT_ARMOR_ENCHANTABLE), (int)2, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.FEET})).exclusiveWith((HolderSet)enchantmentLookup.getOrThrow(EnchantmentTags.BOOTS_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_IMMUNITY, (Object)DamageImmunity.INSTANCE, DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.BURN_FROM_STEPPING)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))).withEffect(EnchantmentEffectComponents.LOCATION_CHANGED, (Object)new ReplaceDisk((LevelBasedValue)new LevelBasedValue.Clamped((LevelBasedValue)LevelBasedValue.perLevel((float)3.0f, (float)1.0f), 0.0f, 16.0f), (LevelBasedValue)LevelBasedValue.constant((float)1.0f), new Vec3i(0, -1, 0), Optional.of(BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesTag((Vec3i)new Vec3i(0, 1, 0), (TagKey)BlockTags.AIR), BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.LAVA}), BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.LAVA}), BlockPredicate.unobstructed()})), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MAGMA_BLOCK), Optional.of(GameEvent.BLOCK_PLACE)), (LootItemCondition.Builder)AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnGround(Boolean.valueOf(true)))), InvertedLootItemCondition.invert((LootItemCondition.Builder)LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().vehicle(EntityPredicate.Builder.entity())))})));
        NemosEnchantments.register(context, SNOW_WALKER, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.FOOT_ARMOR_ENCHANTABLE), (int)2, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.FEET})));
        NemosEnchantments.register(context, COLLECTOR, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.DURABILITY_ENCHANTABLE), (int)3, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)10), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})));
        NemosEnchantments.register(context, WISDOM, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(ItemTags.MINING_ENCHANTABLE), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)10), (int)10, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.withDefaultNamespace((String)"enchantment.wisdom"), NemosAttributes.EXPERIENCE_BONUS.get(), (LevelBasedValue)LevelBasedValue.lookup(List.of(Float.valueOf(0.5f), Float.valueOf(1.0f), Float.valueOf(2.0f)), (LevelBasedValue)LevelBasedValue.perLevel((float)1.5f, (float)0.5f)), AttributeModifier.Operation.ADD_VALUE)));
    }

    private static ResourceKey<Enchantment> createResourceKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nemos_enchantments", (String)id));
    }

    private static void register(BootstrapContext<Enchantment> registry, ResourceKey<Enchantment> key, Enchantment.Builder builder) {
        registry.register(key, (Object)builder.build(key.location()));
    }
}

