/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.enchantments.mixin;

import com.devnemo.nemos.enchantments.enchantment.NemosEnchantments;
import com.devnemo.nemos.enchantments.utils.EnchantmentUtils;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Block.class})
public class BlockMixin {
    @ModifyReturnValue(method={"getDrops(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;"}, at={@At(value="RETURN")})
    private static List<ItemStack> getDrops(List<ItemStack> original, BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, BlockEntity blockEntity, Entity entity, ItemStack itemStack) {
        Block block = blockState.getBlock();
        if (block instanceof CropBlock && itemStack.is(ItemTags.HOES) && EnchantmentUtils.hasEnchantment((Level)serverLevel, NemosEnchantments.REPLANTING, itemStack)) {
            BlockMixin.nemosFarming_replantCrops(serverLevel, blockPos, blockState, block, original);
        }
        return original;
    }

    @ModifyExpressionValue(method={"tryDropExperience"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;processBlockExperience(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;I)I")})
    private int modifyExperienceAmount(int original, @Local(argsOnly=true) ServerLevel level, @Local(argsOnly=true) ItemStack item) {
        float multiplier = EnchantmentUtils.getEnchantmentLevel((Level)level, NemosEnchantments.WISDOM, item);
        if (multiplier == 1.0f) {
            multiplier += 0.5f;
        }
        float result = (float)original * multiplier;
        return (int)result;
    }

    @Unique
    private static void nemosFarming_replantCrops(ServerLevel serverLevel, BlockPos pos, BlockState state, Block block, List<ItemStack> original) {
        serverLevel.setBlock(pos, (BlockState)state.setValue((Property)((CropBlock)block).getAgeProperty(), (Comparable)Integer.valueOf(1)), 3, 512);
        for (ItemStack itemStack : original) {
            if (!itemStack.is(ItemTags.VILLAGER_PLANTABLE_SEEDS)) continue;
            itemStack.setCount(itemStack.getCount() - 1);
            break;
        }
    }
}

