/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.enchantments.mixin;

import com.devnemo.nemos.enchantments.enchantment.NemosEnchantments;
import com.devnemo.nemos.enchantments.utils.EnchantmentUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_1794.class})
public class HoeItemMixin
extends class_1792 {
    public HoeItemMixin(class_1792.class_1793 properties) {
        super(properties);
    }

    public boolean method_7885(@NotNull class_1799 itemStack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1309 user) {
        if (!(user instanceof class_1657)) {
            return super.method_7885(itemStack, state, level, pos, user);
        }
        class_1799 hoe = user.method_6047();
        class_2248 block = state.method_26204();
        boolean isBlockCropBlock = block instanceof class_2302;
        if (isBlockCropBlock) {
            boolean hasFarmersKnowledge = EnchantmentUtils.hasEnchantment(level, NemosEnchantments.FARMERS_KNOWLEDGE, hoe);
            boolean isCropRipe = ((class_2302)block).method_9825(state);
            if (hasFarmersKnowledge) {
                return ((class_1657)user).method_68878() || isCropRipe;
            }
        }
        return true;
    }

    public boolean method_7879(@NotNull class_1799 stack, @NotNull class_1937 level, class_2680 state, @NotNull class_2338 pos, class_1309 miner) {
        class_1799 hoe = miner.method_6047();
        boolean isBlockCropBlock = state.method_26204() instanceof class_2302;
        boolean hasHoeReaperEnchantment = EnchantmentUtils.hasEnchantment(level, NemosEnchantments.REAPER, hoe);
        if (isBlockCropBlock && hasHoeReaperEnchantment) {
            int enchantmentLevel = EnchantmentUtils.getEnchantmentLevel(level, NemosEnchantments.REAPER, hoe);
            int breakingRange = 2 * enchantmentLevel + 1;
            int i = 0;
            while ((double)i < Math.pow(breakingRange, 3.0)) {
                class_2338 nextPos = this.nemosFarming_getNextBlockPos(pos, i, breakingRange);
                this.nemosFarming_breakCrop(level, nextPos, miner);
                ++i;
            }
        }
        return super.method_7879(stack, level, state, pos, miner);
    }

    @Unique
    private class_2338 nemosFarming_getNextBlockPos(class_2338 pos, int i, int breakingRange) {
        int halfRange = breakingRange / 2;
        int x = i / (breakingRange * breakingRange) - halfRange;
        int y = i / breakingRange % breakingRange - halfRange;
        int z = i % breakingRange - halfRange;
        return pos.method_10069(x, y, z);
    }

    @Unique
    private void nemosFarming_breakCrop(class_1937 level, class_2338 pos, class_1309 user) {
        if (!(user instanceof class_1657)) {
            return;
        }
        class_2680 nextBlockState = level.method_8320(pos);
        class_2248 nextBlock = nextBlockState.method_26204();
        if (nextBlock instanceof class_2302 && this.method_7885(user.method_6047(), nextBlockState, level, pos, user)) {
            this.nemosFarming_breakBlock(level, nextBlockState, pos, user);
        }
    }

    @Unique
    private void nemosFarming_breakBlock(class_1937 level, class_2680 blockState, class_2338 pos, class_1309 breakingEntity) {
        if (!(blockState.method_26204() instanceof class_4770)) {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)blockState));
        }
        class_2586 blockEntity = blockState.method_31709() ? level.method_8321(pos) : null;
        class_2248.method_9511((class_2680)blockState, (class_1937)level, (class_2338)pos, (class_2586)blockEntity, (class_1297)breakingEntity, (class_1799)breakingEntity.method_6047());
        if (!EnchantmentUtils.hasEnchantment(level, NemosEnchantments.REPLANTING, breakingEntity.method_6047()) && this.nemosFarming_setBlockState(level, pos)) {
            level.method_43276((class_6880)class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)breakingEntity, (class_2680)blockState));
        }
    }

    @Unique
    private boolean nemosFarming_setBlockState(class_1937 level, class_2338 pos) {
        class_3610 fluidState = level.method_8316(pos);
        return level.method_30092(pos, fluidState.method_15759(), 3, 512);
    }
}

