/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.enchantments.enchantment;

import com.nemonotfound.nemos.enchantments.Constants;
import com.nemonotfound.nemos.enchantments.entity.attribute.ModAttributes;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;

public class ModEnchantments {
    public static final ResourceKey<Enchantment> SOUL_BINDING = ModEnchantments.createResourceKey("soul_binding");
    public static final ResourceKey<Enchantment> CLIMBER = ModEnchantments.createResourceKey("climber");
    public static final ResourceKey<Enchantment> SPRINTER = ModEnchantments.createResourceKey("sprinter");
    public static final ResourceKey<Enchantment> FARMERS_KNOWLEDGE = ModEnchantments.createResourceKey("farmers_knowledge");
    public static final ResourceKey<Enchantment> REAPER = ModEnchantments.createResourceKey("reaper");
    public static final ResourceKey<Enchantment> REPLANTING = ModEnchantments.createResourceKey("replanting");

    public static void bootstrap(BootstrapContext<Enchantment> registerable) {
        Constants.LOG.info("Registering enchantments");
        HolderGetter enchantmentRegistryEntryLookup = registerable.lookup(Registries.ENCHANTMENT);
        HolderGetter itemRegistryEntryLookup = registerable.lookup(Registries.ITEM);
        ModEnchantments.register(registerable, SOUL_BINDING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemRegistryEntryLookup.getOrThrow(ItemTags.DURABILITY_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)25), (Enchantment.Cost)Enchantment.dynamicCost((int)75, (int)25), (int)60, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})).withEffect(EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP));
        ModEnchantments.register(registerable, CLIMBER, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemRegistryEntryLookup.getOrThrow(ItemTags.FOOT_ARMOR_ENCHANTABLE), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.FEET})).exclusiveWith((HolderSet)enchantmentRegistryEntryLookup.getOrThrow(EnchantmentTags.BOOTS_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"nemos_enchantments", (String)"enchantment.climber"), ModAttributes.CLIMBING_EFFICIENCY.get(), (LevelBasedValue)LevelBasedValue.perLevel((float)0.05f), AttributeModifier.Operation.ADD_VALUE)));
        ModEnchantments.register(registerable, SPRINTER, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemRegistryEntryLookup.getOrThrow(ItemTags.FOOT_ARMOR_ENCHANTABLE), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)25, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.FEET})).exclusiveWith((HolderSet)enchantmentRegistryEntryLookup.getOrThrow(EnchantmentTags.BOOTS_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.fromNamespaceAndPath((String)"nemos_enchantments", (String)"enchantment.sprinter"), Attributes.MOVEMENT_SPEED, (LevelBasedValue)LevelBasedValue.perLevel((float)0.02f), AttributeModifier.Operation.ADD_VALUE)));
        ModEnchantments.register(registerable, FARMERS_KNOWLEDGE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemRegistryEntryLookup.getOrThrow(ItemTags.HOES), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)15), (Enchantment.Cost)Enchantment.constantCost((int)65), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        ModEnchantments.register(registerable, REPLANTING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemRegistryEntryLookup.getOrThrow(ItemTags.HOES), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)15), (Enchantment.Cost)Enchantment.constantCost((int)65), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        ModEnchantments.register(registerable, REAPER, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemRegistryEntryLookup.getOrThrow(ItemTags.HOES), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)65, (int)9), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
    }

    private static ResourceKey<Enchantment> createResourceKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nemos_enchantments", (String)id));
    }

    private static void register(BootstrapContext<Enchantment> registry, ResourceKey<Enchantment> key, Enchantment.Builder builder) {
        registry.register(key, (Object)builder.build(key.location()));
    }
}

